/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jexx.base.Tuple2;
import jexx.convert.Convert;
import jexx.poi.exception.POIException;
import jexx.poi.header.AbstractDataHeader;
import jexx.poi.header.ArrayDataHeader;
import jexx.poi.header.DefaultDataHeader;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.TreeDataHeader;
import jexx.poi.meta.AbstractMetaSheet;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.IMetaReader;
import jexx.poi.meta.Metas;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.Node;
import jexx.poi.meta.node.TreeNode;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.RowOperationUtil;
import jexx.time.DateTime;
import jexx.time.DateUtil;
import jexx.util.Assert;
import jexx.util.ClassLoaderUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSheetReader
extends AbstractMetaSheet
implements IMetaReader {
    private static final Logger LOG = LoggerFactory.getLogger(MetaSheetReader.class);
    protected Metas excelMeta;

    public MetaSheetReader(Sheet sheet) {
        this.sheet = sheet;
    }

    public Metas readMeta() {
        Row row;
        String cellValue;
        this.excelMeta = new Metas();
        Iterator rowIterator = this.sheet.iterator();
        while (rowIterator.hasNext() && !StringUtil.isEmpty((CharSequence)(cellValue = CellOperateUtil.getStringCellValue((row = (Row)rowIterator.next()).getCell(0))))) {
            if ("__INFO__START".equals(cellValue)) {
                this.readInfo(this.excelMeta, rowIterator);
                continue;
            }
            if ("__METADATA__START".equals(cellValue)) {
                String metaType = CellOperateUtil.getStringCellValue(row.getCell(1));
                DVConstraintType constraintType = DVConstraintType.valueOf(metaType);
                if (DVConstraintType.ARRAY == constraintType) {
                    ArrayMeta arrayMeta = this.readArrayMeta(rowIterator);
                    this.excelMeta.addMeta(arrayMeta);
                    continue;
                }
                if (DVConstraintType.TREE == constraintType) {
                    TreeMeta treeMeta = this.readTreeMeta(rowIterator);
                    this.excelMeta.addMeta(treeMeta);
                    continue;
                }
                throw new IllegalArgumentException(StringUtil.format((String)"constraintType[{}] can't handle", (Object[])new Object[]{metaType}));
            }
            if (!"__HEADER__START".equals(cellValue)) continue;
            String headerName = CellOperateUtil.getStringCellValue(row.getCell(1));
            Headers headers = this.readerHeaders(headerName, rowIterator);
            this.excelMeta.addHeaders(headers);
        }
        return this.excelMeta;
    }

    private void readInfo(Metas metas, Iterator<Row> rowIterator) {
        HashMap<String, String> customProperties = new HashMap<String, String>(16);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            if (row == null) {
                throw new POIException("meta \u683c\u5f0f\u5f02\u5e38,\u8bfb\u53d6\u4e0d\u5230\u4e0b\u4e00\u884c\u6570\u636e");
            }
            String value1 = CellOperateUtil.getStringCellValue(row.getCell(0));
            if ("__END__".equals(value1)) break;
            if (StringUtil.isEmpty((CharSequence)value1) || value1.startsWith("__")) {
                throw new POIException("meta \u683c\u5f0f\u5f02\u5e38, value1=" + value1);
            }
            String value2 = CellOperateUtil.getStringCellValue(row.getCell(1));
            if ("META_VERSION".equals(value1)) {
                metas.setVersion(value2);
                continue;
            }
            if ("META_CREATE_TIME".equals(value1)) {
                if (!StringUtil.isNotEmpty((CharSequence)value2)) continue;
                try {
                    DateTime createTime = DateUtil.parseDateTime((String)value2);
                    metas.setCreateTime((Date)createTime);
                }
                catch (Exception e) {
                    LOG.warn("", (Throwable)e);
                }
                continue;
            }
            customProperties.put(value1, value2);
        }
        metas.addProperty(customProperties);
    }

    private ArrayMeta readArrayMeta(Iterator<Row> rowIterator) {
        Assert.isTrue((boolean)rowIterator.hasNext(), (String)"no value row", (Object[])new Object[0]);
        Row valueRow = rowIterator.next();
        Assert.isTrue((boolean)rowIterator.hasNext(), (String)"no label row", (Object[])new Object[0]);
        Row labelRow = rowIterator.next();
        Tuple2<String, List<INode>> tuple2 = this.readValue(valueRow, labelRow);
        Assert.isTrue((boolean)rowIterator.hasNext(), (String)"array no end row", (Object[])new Object[0]);
        Row endRow = rowIterator.next();
        String endTag = CellOperateUtil.getStringCellValue(endRow.getCell(0));
        Assert.isTrue((boolean)"__END__".equals(endTag), (String)"ArrayMeta must has end tag!", (Object[])new Object[0]);
        return new ArrayMeta((String)tuple2.getFirst(), (List)tuple2.getSecond());
    }

    private TreeMeta readTreeMeta(Iterator<Row> rowIterator) {
        String endTag;
        Row row;
        HashMap<String, TreeNode> treeMap = new HashMap<String, TreeNode>(16);
        TreeNode rootTree = null;
        while (rowIterator.hasNext() && (row = rowIterator.next()) != null && !"__END__".equals(endTag = CellOperateUtil.getStringCellValue(row.getCell(0)))) {
            Assert.isTrue((boolean)rowIterator.hasNext(), (String)"tree has no label row", (Object[])new Object[0]);
            Row labelRow = rowIterator.next();
            Tuple2<String, List<INode>> tuple2 = this.readValue(row, labelRow);
            String treeName = (String)tuple2.getFirst();
            int lastIndex = treeName.lastIndexOf("_");
            String name = treeName.substring(lastIndex + 1);
            TreeNode tree = (TreeNode)treeMap.get(treeName);
            if (tree == null) {
                tree = new TreeNode(name);
                if (rootTree == null) {
                    tree.setRoot(true);
                    rootTree = tree;
                }
                treeMap.put(treeName, tree);
            }
            if (!CollectionUtil.isNotEmpty((Collection)((Collection)tuple2.getSecond()))) continue;
            List<TreeNode> children = tree.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                tree.setChildren(children);
            }
            for (INode node : (List)tuple2.getSecond()) {
                TreeNode tNode = new TreeNode(node.getValue(), node.getLabel());
                tNode.setParent(tree);
                String fullLabel = treeName.concat("_").concat(node.getLabel() != null ? node.getLabel().toString() : "");
                treeMap.putIfAbsent(fullLabel, tNode);
                children.add(tNode);
            }
        }
        if (rootTree == null) {
            throw new NullPointerException("Root tree not find!");
        }
        this.repairTree(rootTree);
        return new TreeMeta(rootTree.getFullLabel(), rootTree);
    }

    private Headers readerHeaders(String headerName, Iterator<Row> rowIterator) {
        String endTag;
        Row row;
        Headers headers = new Headers(headerName);
        while (rowIterator.hasNext() && (row = rowIterator.next()) != null && !"__END__".equals(endTag = CellOperateUtil.getStringCellValue(row.getCell(0)))) {
            IMeta meta;
            String metaName;
            List<Object> list = RowOperationUtil.readRow(row);
            Assert.notNull(list);
            Assert.isTrue((list.size() >= 4 ? 1 : 0) != 0);
            String key = list.get(0).toString();
            String value = list.get(1).toString();
            DVConstraintType dvConstraintType = DVConstraintType.valueOf(list.get(3).toString());
            if (DVConstraintType.DEFAULT == dvConstraintType) {
                DefaultDataHeader header = new DefaultDataHeader(key, value);
                this.loadHeader(header, list);
                headers.addHeader(header);
                continue;
            }
            if (DVConstraintType.ARRAY == dvConstraintType) {
                Assert.isTrue((list.size() >= 5 ? 1 : 0) != 0, (String)"headerName={},key={}", (Object[])new Object[]{headerName, key});
                metaName = list.get(4).toString();
                meta = this.excelMeta.getMeta(metaName);
                Assert.notNull((Object)meta, (String)"not find meta[{}]", (Object[])new Object[]{metaName});
                Assert.isInstanceOf(ArrayMeta.class, (Object)meta);
                ArrayMeta arrayMeta = (ArrayMeta)meta;
                ArrayDataHeader arrayHeader = new ArrayDataHeader(key, value, arrayMeta);
                this.loadHeader(arrayHeader, list);
                headers.addHeader(arrayHeader);
                continue;
            }
            if (DVConstraintType.TREE == dvConstraintType) {
                Assert.isTrue((list.size() >= 6 ? 1 : 0) != 0, (String)"headerName={},key={}", (Object[])new Object[]{headerName, key});
                metaName = list.get(4).toString();
                meta = this.excelMeta.getMeta(metaName);
                Assert.notNull((Object)meta, (String)"not find meta[{}]", (Object[])new Object[]{metaName});
                Assert.isInstanceOf(TreeMeta.class, (Object)meta);
                TreeMeta treeMeta = (TreeMeta)meta;
                short referHeaderColumnNum = Convert.toShort((Object)list.get(5), (Short)-1);
                IDataHeader referHeader = headers.getDataHeaderByColumnNum(referHeaderColumnNum);
                TreeDataHeader treeHeader = new TreeDataHeader(key, value, treeMeta, referHeader);
                this.loadHeader(treeHeader, list);
                headers.addHeader(treeHeader);
                continue;
            }
            throw new POIException("not right for header");
        }
        return headers;
    }

    private Tuple2<String, List<INode>> readValue(Row valueRow, Row labelRow) {
        Object value;
        String name = CellOperateUtil.getStringCellValue(valueRow.getCell(0));
        int lastCellNum = valueRow.getLastCellNum();
        ArrayList<Node> values = new ArrayList<Node>();
        for (int i = 1; i <= lastCellNum && (value = CellOperateUtil.getCellValue(valueRow.getCell(i))) != null; ++i) {
            Object label = CellOperateUtil.getCellValue(labelRow.getCell(i));
            Node node = new Node(value, label);
            values.add(node);
        }
        return new Tuple2((Object)name, values);
    }

    protected void repairTree(TreeNode treeNode) {
        if (CollectionUtil.isEmpty(treeNode.getChildren())) {
            treeNode.setLeaf(true);
            return;
        }
        for (TreeNode c : treeNode.getChildren()) {
            this.repairTree(c);
        }
    }

    protected void loadHeader(AbstractDataHeader<?> header, List<Object> list) {
        String multiValueStr;
        Object multiValueObj;
        Assert.notNull(list);
        Assert.isTrue((list.size() >= 4 ? 1 : 0) != 0);
        short columnIndex = Convert.toShort((Object)list.get(2));
        header.setStartColumnNum(columnIndex);
        header.setEndColumnNum(columnIndex);
        if (list.size() >= 7 && (multiValueObj = list.get(6)) != null && StringUtil.isNotEmpty((CharSequence)(multiValueStr = multiValueObj.toString()))) {
            boolean isMultiValue;
            String[] arr = StringUtil.split((String)multiValueStr, (String)",");
            boolean bl = isMultiValue = arr.length >= 1 && "1".equals(arr[0]);
            if (isMultiValue) {
                Class multiValueCollectionType = arr.length >= 2 ? ClassLoaderUtil.loadClass((String)arr[1]) : null;
                Class multiValueElementType = arr.length >= 3 ? ClassLoaderUtil.loadClass((String)arr[2]) : null;
                header.withMultiValue(multiValueCollectionType, multiValueElementType);
            }
        }
    }
}

