/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import jexx.convert.Convert;
import jexx.poi.constant.EmbeddedDataStyleName;
import jexx.poi.header.AbstractDataHeader;
import jexx.poi.header.ArrayDataHeader;
import jexx.poi.header.DefaultDataHeader;
import jexx.poi.header.HeaderModifyField;
import jexx.poi.header.Headers;
import jexx.poi.header.HeadersFactory;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.TreeDataHeader;
import jexx.poi.header.annotation.HeaderCollection;
import jexx.poi.header.annotation.HeaderColumn;
import jexx.poi.header.annotation.HeaderIgnore;
import jexx.poi.header.annotation.HeaderMeta;
import jexx.poi.header.annotation.HeaderTable;
import jexx.poi.header.factory.HeaderColumnSelectMode;
import jexx.poi.header.factory.HeaderFieldImpl;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.Metas;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.Node;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.ClassUtil;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;
import jexx.util.StringUtil;

public class HeadersFactoryImpl
implements HeadersFactory {
    private static final String INTERNAL_CELL_STYLE_PREFIX = "_";
    private String name;
    private HeaderColumnSelectMode selectMode = HeaderColumnSelectMode.ALL;
    private Class<?>[] groups;
    private Map<String, IWrapCellStyle> cellStyleMap;
    private IWrapCellStyle defaultHeaderCellStyle = CellStyleSets.HEADER_CELL_STYLE;
    private IWrapCellStyle defaultDataCellStyle = CellStyleSets.DATA_CELL_STYLE;
    private Metas metas;
    private final Set<String> ignoreFields = new HashSet<String>();
    private final Map<String, HeaderModifyField> canModifyFields = new HashMap<String, HeaderModifyField>(16);
    private Map<String, String> i18nMap;
    private ResourceBundle resourceBundle;
    private final List<IDataHeader> replaceHeaders = new ArrayList<IDataHeader>();
    private final List<Operation> operations = new ArrayList<Operation>();

    public HeadersFactoryImpl() {
        this.initCellStyle();
    }

    @Override
    public HeadersFactory withCellStyle(String name, IWrapCellStyle cellStyle) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((CharSequence)name), (String)"name is not empty!", (Object[])new Object[0]);
        Assert.isTrue((!name.startsWith(INTERNAL_CELL_STYLE_PREFIX) ? 1 : 0) != 0, (String)"name cannot start with '_' ", (Object[])new Object[0]);
        this.cellStyleMap.put(name, cellStyle);
        return this;
    }

    private void initCellStyle() {
        if (this.cellStyleMap == null) {
            HashMap<String, IWrapCellStyle> map = new HashMap<String, IWrapCellStyle>(16);
            EmbeddedDataStyleName.wrapEmbeddedDataStyle(map);
            this.cellStyleMap = map;
        }
    }

    @Override
    public HeadersFactory withDefaultHeaderCellStyle(IWrapCellStyle cellStyle) {
        this.defaultHeaderCellStyle = cellStyle;
        return this;
    }

    @Override
    public HeadersFactory withDefaultDataCellStyle(IWrapCellStyle cellStyle) {
        this.defaultDataCellStyle = cellStyle;
        return this;
    }

    @Override
    public HeadersFactory withMetas(Metas metas) {
        this.metas = metas;
        return this;
    }

    @Override
    public HeadersFactory select(HeaderColumnSelectMode mode) {
        this.selectMode = mode;
        return this;
    }

    @Override
    public HeadersFactory group(Class<?> ... groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public HeadersFactory ignoreField(String ... fields) {
        Collections.addAll(this.ignoreFields, fields);
        return this;
    }

    @Override
    public HeadersFactory ignoreField(Collection<String> fields) {
        this.ignoreFields.addAll(fields);
        return this;
    }

    @Override
    public HeadersFactory modify(String name, HeaderModifyField field) {
        this.canModifyFields.put(name, field);
        return this;
    }

    @Override
    public HeadersFactory i18n(Map<String, String> i18nMap) {
        this.i18nMap = i18nMap;
        return this;
    }

    @Override
    public HeadersFactory i18n(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        return this;
    }

    protected String convertValue(String value) {
        if (value == null) {
            return null;
        }
        String newValue = value;
        if (this.i18nMap != null) {
            newValue = this.i18nMap.get(newValue);
        }
        if (newValue == null && this.resourceBundle != null) {
            newValue = this.resourceBundle.getString(value);
        }
        return newValue == null ? value : newValue;
    }

    @Override
    public HeadersFactory replace(IDataHeader header) {
        this.replaceHeaders.add(header);
        return this;
    }

    @Override
    public HeadersFactory addHeaderAfter(String headerName, ICustomHeader header) {
        Operation operation = new Operation();
        operation.headerName = headerName;
        operation.type = 2;
        operation.header = header;
        this.operations.add(operation);
        return this;
    }

    @Override
    public HeadersFactory addHeaderBefore(String headerName, ICustomHeader header) {
        Operation operation = new Operation();
        operation.headerName = headerName;
        operation.type = 1;
        operation.header = header;
        this.operations.add(operation);
        return this;
    }

    @Override
    public Headers build(Class<?> clazz) {
        String name;
        if (HeaderColumnSelectMode.ALL == this.selectMode) {
            name = "default";
        } else {
            HeaderTable table = (HeaderTable)ReflectUtil.getAnnotationOfClass(clazz, HeaderTable.class);
            Assert.notNull((Object)table, (String)"Class[{}] no support to build header", (Object[])new Object[]{clazz});
            name = table.name();
        }
        List<HeaderFieldImpl> headerFields = new ArrayList<HeaderFieldImpl>();
        this.doScanCollection("", clazz, headerFields);
        HashMap<String, IDataHeader> headerMap = new HashMap<String, IDataHeader>(16);
        this.doRecursionHeader(new ArrayList<HeaderFieldImpl>(headerFields), headerMap);
        if (CollectionUtil.isNotEmpty(this.replaceHeaders)) {
            this.replaceHeaders.forEach(s -> {
                if (headerMap.get(s.getKey()) != null) {
                    headerMap.put(s.getKey(), (IDataHeader)s);
                }
            });
        }
        headerFields = headerFields.stream().sorted(Comparator.comparingInt(HeaderFieldImpl::getGroupOrder).thenComparing(HeaderFieldImpl::getOrder)).collect(Collectors.toList());
        Map<String, List<Operation>> operationGroupMap = this.operations.stream().collect(Collectors.groupingBy(s -> s.headerName));
        Headers headers = new Headers(name);
        headers.setDefaultHeaderCellStyle(this.defaultHeaderCellStyle);
        headers.setDefaultDataCellStyle(this.defaultDataCellStyle);
        for (HeaderFieldImpl field : headerFields) {
            IDataHeader dataHeader = (IDataHeader)headerMap.get(field.getFieldName());
            Assert.notNull((Object)dataHeader);
            List<Operation> operations = operationGroupMap.remove(field.getFieldName());
            if (CollectionUtil.isEmpty(operations)) {
                headers.addHeader(dataHeader);
                continue;
            }
            for (Operation operation : operations) {
                if (1 != operation.type) continue;
                headers.addHeader(operation.header);
            }
            headers.addHeader(dataHeader);
            for (Operation operation : operations) {
                if (2 != operation.type) continue;
                headers.addHeader(operation.header);
            }
        }
        Assert.isEmpty(operationGroupMap, (String)"can't handle this custom header, {}", (Object[])new Object[]{operationGroupMap.keySet()});
        headers.flush();
        return headers;
    }

    private void doScanCollection(String prefix, Class<?> clazz, List<HeaderFieldImpl> headerFields) {
        Object[] fields = ReflectUtil.getFields(clazz);
        Assert.notEmpty((Object[])fields, (String)"Class {} has no field to build headers!", (Object[])new Object[]{clazz});
        for (Object field : fields) {
            HeaderFieldImpl headerField;
            String fieldName = prefix.concat(((Field)field).getName());
            if (this.ignoreFields.contains(fieldName)) continue;
            HeaderIgnore headerIgnore = ((Field)field).getAnnotation(HeaderIgnore.class);
            HeaderColumn headerColumn = ((Field)field).getAnnotation(HeaderColumn.class);
            HeaderCollection headerCollection = ((Field)field).getAnnotation(HeaderCollection.class);
            Assert.isTrue((headerColumn == null || headerCollection == null ? 1 : 0) != 0, (String)"A field can't  support HeaderColumn and HeaderCollection at same time", (Object[])new Object[0]);
            if (HeaderColumnSelectMode.ALL == this.selectMode) {
                headerField = new HeaderFieldImpl(fieldName, fieldName);
                this.modifyField(headerField);
                headerFields.add(headerField);
                continue;
            }
            if (HeaderColumnSelectMode.ALL_WITH_TAG != this.selectMode && HeaderColumnSelectMode.ONLY_TAG != this.selectMode || headerIgnore != null) continue;
            if (headerCollection != null) {
                Assert.isTrue((((Field)field).getType().isArray() || List.class == ((Field)field).getType() || Set.class == ((Field)field).getType() ? 1 : 0) != 0, (String)"field [{}] is not array or collection", (Object[])new Object[]{fieldName});
                Class componentType = ((Field)field).getType().isArray() ? ((Field)field).getType().getComponentType() : ClassUtil.getComponentType((Type)((Field)field).getGenericType());
                Assert.notNull((Object)componentType, (String)"check field [{}] because HeaderCollection", (Object[])new Object[]{fieldName});
                this.doScanCollection(fieldName.concat("[]."), componentType, headerFields);
                continue;
            }
            if (headerColumn != null) {
                boolean metaEnabled;
                if (!this.checkGroup(headerColumn)) continue;
                ArrayMeta meta = this.parseHeaderMeta((Field)field);
                boolean bl = metaEnabled = meta != null && this.metas != null;
                if (metaEnabled) {
                    this.metas.addMeta(meta);
                }
                HeaderFieldImpl headerField2 = new HeaderFieldImpl();
                headerField2.setFieldName(headerColumn.list() ? fieldName.concat("[]") : fieldName);
                headerField2.setValue(headerColumn.value());
                headerField2.setGroupOrder(headerColumn.groupOrder());
                headerField2.setOrder(headerColumn.order());
                headerField2.setHeaderCellStyle(headerColumn.headerCellStyle());
                headerField2.setDataCellStyle(headerColumn.dataCellStyle());
                headerField2.setReferKey(headerColumn.referKey());
                headerField2.setMeta(metaEnabled ? meta.getName() : headerColumn.meta());
                headerField2.setValid(headerColumn.valid());
                this.modifyField(headerField2);
                boolean multiValue = headerColumn.multiValue();
                headerField2.setMultiValue(multiValue);
                if (multiValue) {
                    Class<?> fieldType = ((Field)field).getType();
                    Assert.isTrue((fieldType.isArray() || List.class.isAssignableFrom(fieldType) || Set.class.isAssignableFrom(fieldType) ? 1 : 0) != 0, (String)"field [{}] is not array or collection", (Object[])new Object[]{fieldName});
                    headerField2.setMultiValueCollectionType(fieldType);
                    Class componentType = fieldType.isArray() ? fieldType.getComponentType() : ClassUtil.getComponentType((Type)((Field)field).getGenericType());
                    headerField2.setMultiValueElementType(componentType);
                }
                headerFields.add(headerField2);
                continue;
            }
            if (HeaderColumnSelectMode.ALL_WITH_TAG != this.selectMode) continue;
            headerField = new HeaderFieldImpl(fieldName, fieldName);
            this.modifyField(headerField);
            headerFields.add(headerField);
        }
        Assert.notEmpty(headerFields, (String)"No field to build headers!", (Object[])new Object[0]);
    }

    private ArrayMeta parseHeaderMeta(Field field) {
        HeaderMeta headerMeta = field.getAnnotation(HeaderMeta.class);
        if (headerMeta == null) {
            return null;
        }
        String[] strValues = headerMeta.values();
        Object[] labels = headerMeta.labels();
        if (ArrayUtil.isNotEmpty((Object[])labels) && labels.length != strValues.length) {
            throw new IllegalArgumentException("labels' length is not equal to strValues");
        }
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (int i = 0; i < strValues.length; ++i) {
            String value = String.class == headerMeta.valueType() ? strValues[i] : Convert.convert(headerMeta.valueType(), (Object)strValues[i]);
            Object label = value;
            if (ArrayUtil.isNotEmpty((Object[])labels)) {
                label = labels[i];
            }
            nodes.add(new Node(value, label));
        }
        return new ArrayMeta(headerMeta.name(), nodes);
    }

    private void doRecursionHeader(List<HeaderFieldImpl> headerFieldImpls, Map<String, IDataHeader> dataHeaderMap) {
        int size = headerFieldImpls.size();
        Iterator<HeaderFieldImpl> headerFieldIterator = headerFieldImpls.iterator();
        while (headerFieldIterator.hasNext()) {
            AbstractDataHeader header;
            HeaderFieldImpl headerFieldImpl = headerFieldIterator.next();
            String referKey = headerFieldImpl.getReferKey();
            IDataHeader referHeader = null;
            if (StringUtil.isNotEmpty((CharSequence)referKey) && (referHeader = dataHeaderMap.get(referKey)) == null) continue;
            IWrapCellStyle headerCellStyle = this.defaultHeaderCellStyle;
            IWrapCellStyle dataCellStyle = this.defaultDataCellStyle;
            if (this.cellStyleMap != null) {
                if (!"".equals(headerFieldImpl.getHeaderCellStyle())) {
                    headerCellStyle = this.cellStyleMap.get(headerFieldImpl.getHeaderCellStyle());
                }
                if (!"".equals(headerFieldImpl.getDataCellStyle())) {
                    dataCellStyle = this.cellStyleMap.get(headerFieldImpl.getDataCellStyle());
                }
            }
            IMeta meta = null;
            if (this.metas != null && StringUtil.isNotEmpty((CharSequence)headerFieldImpl.getMeta())) {
                meta = this.metas.getMeta(headerFieldImpl.getMeta());
            }
            String value = this.convertValue(headerFieldImpl.getValue());
            if (meta == null) {
                header = new DefaultDataHeader(headerFieldImpl.getFieldName(), value);
            } else if (meta instanceof ArrayMeta) {
                header = new ArrayDataHeader(headerFieldImpl.getFieldName(), value, (ArrayMeta)meta);
            } else if (meta instanceof TreeMeta) {
                header = new TreeDataHeader(headerFieldImpl.getFieldName(), value, (TreeMeta)meta, referHeader);
            } else {
                throw new UnsupportedOperationException(StringUtil.format((String)"cannot handle this meta \"{}\"", (Object[])new Object[]{meta}));
            }
            header.setValid(headerFieldImpl.isValid());
            header.setHeaderCellStyle(headerCellStyle);
            header.setDataCellStyle(dataCellStyle);
            if (headerFieldImpl.isMultiValue()) {
                header.withMultiValue(headerFieldImpl.getMultiValueCollectionType(), headerFieldImpl.getMultiValueElementType());
            }
            dataHeaderMap.put(headerFieldImpl.getFieldName(), header);
            headerFieldIterator.remove();
        }
        if (headerFieldImpls.size() == size) {
            String referKeys = StringUtil.join(headerFieldImpls, (String)",", HeaderFieldImpl::getReferKey);
            throw new IllegalArgumentException(StringUtil.format((String)"Please check the header column's referKey, referKeys=[{}] ", (Object[])new Object[]{referKeys}));
        }
        if (headerFieldImpls.size() > 0) {
            this.doRecursionHeader(headerFieldImpls, dataHeaderMap);
        }
    }

    private boolean checkGroup(HeaderColumn headerColumn) {
        if (headerColumn == null || ArrayUtil.isEmpty((Object[])headerColumn.group()) || ArrayUtil.isEmpty((Object[])this.groups)) {
            return true;
        }
        for (Class c : headerColumn.group()) {
            for (Class<?> b : this.groups) {
                if (c != b) continue;
                return true;
            }
        }
        return false;
    }

    private void modifyField(HeaderFieldImpl field) {
        HeaderModifyField modifyField = this.canModifyFields.get(field.getFieldName());
        if (modifyField != null) {
            field.setGroupOrder(modifyField.getGroupOrder());
            field.setOrder(modifyField.getOrder());
        }
    }

    private static class Operation {
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public String headerName;
        public int type;
        public ICustomHeader header;

        private Operation() {
        }
    }
}

