/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.Map;
import java.util.Stack;
import jexx.poi.header.IHeader;
import jexx.poi.header.label.LabelUnwrapFunction;
import jexx.poi.header.label.LabelWrapFunction;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.TreeMeta;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.util.Assert;
import jexx.util.StringUtil;

public interface IDataHeader
extends IHeader {
    public boolean isMultiValue();

    public Class<?> getValueCollectionType();

    public Class<?> getValueElementType();

    default public String getLabelDelimiter() {
        return ",";
    }

    public IDataHeader getReferHeader();

    public DVConstraintType getDVConstraintType();

    public IMeta getMeta();

    public boolean isValid();

    public LabelWrapFunction getWrapLabelFunction();

    public LabelUnwrapFunction getUnwrapLabelFunction();

    public IWrapCellStyle getDataCellStyle();

    public Object getValueByLabel(Map<String, Object> var1);

    default public String createDataValidateFormula(int startRowNum) {
        IMeta meta = this.getMeta();
        Assert.notNull((Object)meta, (String)"header's meta cannot be null!", (Object[])new Object[0]);
        StringBuilder nameBuilder = new StringBuilder("INDIRECT(SUBSTITUTE(CONCATENATE(");
        nameBuilder.append("\"").append('_').append("\",");
        nameBuilder.append(",\"").append(meta.getName()).append("\"");
        if (!(meta instanceof ArrayMeta)) {
            if (meta instanceof TreeMeta) {
                Stack<IDataHeader> stack = new Stack<IDataHeader>();
                for (IDataHeader refer = this.getReferHeader(); refer != null; refer = refer.getReferHeader()) {
                    stack.push(refer);
                }
                if (!stack.isEmpty()) {
                    IDataHeader fetch = (IDataHeader)stack.pop();
                    while (fetch != null) {
                        nameBuilder.append(",\"").append("_").append("\",");
                        String columnNo = CellOperateUtil.toColumnLabel(fetch.getStartColumnNum());
                        nameBuilder.append("$").append(columnNo).append("").append(startRowNum);
                        if (!stack.isEmpty()) {
                            fetch = (IDataHeader)stack.pop();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException(StringUtil.format((String)"cannot handle this meta, meta[{}]!", (Object[])new Object[]{meta.getClass()}));
            }
        }
        nameBuilder.append("),\" \",\"\"))");
        return nameBuilder.toString();
    }
}

