/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.ArrayList;
import java.util.List;
import jexx.poi.header.IGroupHeader;
import jexx.poi.header.IHeader;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;

public class GroupHeader
implements IGroupHeader {
    protected String value;
    protected int startColumnNum;
    protected int endColumnNum;
    protected IWrapCellStyle headerCellStyle;
    private List<IHeader> children = new ArrayList<IHeader>();

    public GroupHeader(String value, IWrapCellStyle headerCellStyle) {
        this.value = value;
        this.headerCellStyle = headerCellStyle;
    }

    public GroupHeader(String value) {
        this(value, CellStyleSets.HEADER_CELL_STYLE);
    }

    public void addHeader(IHeader header) {
        this.children.add(header);
    }

    @Override
    public List<IHeader> getChildren() {
        return this.children;
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getStartColumnNum() {
        return this.startColumnNum;
    }

    @Override
    public void setStartColumnNum(int startColumnNum) {
        this.startColumnNum = startColumnNum;
    }

    @Override
    public int getEndColumnNum() {
        return this.endColumnNum;
    }

    @Override
    public void setEndColumnNum(int endColumnNum) {
        this.endColumnNum = endColumnNum;
    }

    @Override
    public int getColumnCount() {
        return this.children.stream().mapToInt(IHeader::getColumnCount).sum();
    }

    @Override
    public IWrapCellStyle getHeaderCellStyle() {
        return this.headerCellStyle;
    }
}

