/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jexx.convert.Convert;
import jexx.poi.header.AbstractHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.label.LabelFunction;
import jexx.poi.header.label.LabelUnwrapFunction;
import jexx.poi.header.label.LabelWrapFunction;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public abstract class AbstractDataHeader<T extends AbstractDataHeader<T>>
extends AbstractHeader
implements IDataHeader {
    protected boolean valid = true;
    protected boolean multiValue = false;
    protected Class<?> valueCollectionType;
    protected Class<?> valueElementType;
    protected boolean multiValueIsSet = false;
    protected LabelWrapFunction labelWrapFunction;
    protected LabelUnwrapFunction labelUnwrapFunction;
    private IWrapCellStyle dataCellStyle;

    public AbstractDataHeader(String key, String value) {
        this(key, value, 1);
    }

    public AbstractDataHeader(String key, String value, int columnCount) {
        this(key, value, columnCount, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    public AbstractDataHeader(String key, String value, int columnCount, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        Objects.requireNonNull(key);
        this.key = key;
        this.value = value;
        this.columnCount = columnCount;
        this.headerCellStyle = headerCellStyle;
        this.dataCellStyle = dataCellStyle;
    }

    private T _this() {
        return (T)this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public T setValid(boolean valid) {
        this.valid = valid;
        return this._this();
    }

    @Override
    public boolean isMultiValue() {
        return this.multiValue;
    }

    public T setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
        return this._this();
    }

    @Override
    public Class<?> getValueCollectionType() {
        return this.valueCollectionType;
    }

    protected void setValueCollectionType(Class<?> valueCollectionType) {
        if (valueCollectionType == null || !valueCollectionType.isArray() && !List.class.isAssignableFrom(valueCollectionType) && !Set.class.isAssignableFrom(valueCollectionType)) {
            throw new IllegalArgumentException("multiValueType must be an array, a list , or a set");
        }
        this.valueCollectionType = valueCollectionType;
    }

    @Override
    public Class<?> getValueElementType() {
        return this.valueElementType;
    }

    public T withMultiValue(Class<?> valueCollectionType, Class<?> valueElementType) {
        if (this.multiValueIsSet) {
            throw new UnsupportedOperationException("Not allow to invoke this method repeatedly");
        }
        if (valueCollectionType == null || !valueCollectionType.isArray() && !List.class.isAssignableFrom(valueCollectionType) && !Set.class.isAssignableFrom(valueCollectionType)) {
            throw new IllegalArgumentException("valueCollectionType must be an array, a list , or a set");
        }
        if (!valueCollectionType.isArray() && valueElementType == null) {
            throw new IllegalArgumentException("'valueElementType' cannot be null if collection");
        }
        IDataHeader referHeader = this;
        while ((referHeader = referHeader.getReferHeader()) != null) {
            if (!referHeader.isMultiValue()) continue;
            throw new UnsupportedOperationException("header(" + referHeader.getKey() + ") is multi-value's header, so failed");
        }
        this.valueCollectionType = valueCollectionType;
        this.valueElementType = valueElementType;
        this.multiValue = true;
        this.multiValueIsSet = true;
        return this._this();
    }

    public T withMultiValue(Class<?> valueCollectionType) {
        if (valueCollectionType == null || !valueCollectionType.isArray()) {
            throw new IllegalArgumentException("valueCollectionType must be an array");
        }
        return this.withMultiValue(valueCollectionType, null);
    }

    public T label(LabelFunction labelFunction) {
        this.wrapLabel(labelFunction);
        this.unwrapLabel(labelFunction);
        return this._this();
    }

    public T wrapLabel(LabelWrapFunction labelWrapFunction) {
        this.labelWrapFunction = labelWrapFunction;
        return this._this();
    }

    public T unwrapLabel(LabelUnwrapFunction labelUnwrapFunction) {
        this.labelUnwrapFunction = labelUnwrapFunction;
        return this._this();
    }

    public T setDataCellStyle(IWrapCellStyle dataCellStyle) {
        this.dataCellStyle = dataCellStyle;
        return this._this();
    }

    @Override
    public LabelWrapFunction getWrapLabelFunction() {
        return this.labelWrapFunction;
    }

    @Override
    public LabelUnwrapFunction getUnwrapLabelFunction() {
        return this.labelUnwrapFunction;
    }

    @Override
    public IWrapCellStyle getDataCellStyle() {
        return this.dataCellStyle;
    }

    @Override
    public Object getValueByLabel(Map<String, Object> labelMap) {
        Object value;
        Object labelObj = labelMap.get(this.key);
        if (labelObj == null) {
            return null;
        }
        String label = StringUtil.str((Object)labelObj);
        if (this.isMultiValue()) {
            int i;
            Class<?> collectionType = this.getValueCollectionType();
            Assert.notNull(collectionType, (String)"valueCollectionType not null", (Object[])new Object[0]);
            String[] labels = StringUtil.split((String)label, (String)this.getLabelDelimiter());
            Object[] values = new Object[labels.length];
            for (i = 0; i < labels.length; ++i) {
                INode node;
                String fullLabel = this.getFullLabel(labels[i], labelMap);
                Object v = this.getMeta() != null ? ((node = this.getMeta().getNodeByFullLabel(fullLabel)) != null ? node.getValue() : null) : fullLabel;
                if (collectionType.isArray()) {
                    v = Convert.convert(collectionType.getComponentType(), (Object)v);
                } else {
                    Class<?> elementType = this.getValueElementType();
                    Assert.notNull(elementType, (String)"valueElementType not null", (Object[])new Object[0]);
                    v = Convert.convert(elementType, (Object)v);
                }
                values[i] = v;
            }
            if (collectionType.isArray()) {
                value = Array.newInstance(collectionType.getComponentType(), values.length);
                for (i = 0; i < values.length; ++i) {
                    Array.set(value, i, values[i]);
                }
            } else {
                Class<?> elementType = this.getValueElementType();
                Assert.notNull(elementType, (String)"valueElementType not null", (Object[])new Object[0]);
                Collection list = CollectionUtil.createCollection(collectionType, elementType, (int)0);
                Collections.addAll(list, values);
                value = list;
            }
        } else {
            INode node;
            String fullLabel = this.getFullLabel(label, labelMap);
            value = this.getMeta() != null ? ((node = this.getMeta().getNodeByFullLabel(fullLabel)) != null ? node.getValue() : null) : fullLabel;
        }
        return value;
    }

    protected String getFullLabel(String label, Map<?, ?> data) {
        if (label == null) {
            return null;
        }
        ArrayList<String> lvs = new ArrayList<String>();
        lvs.add(label);
        for (IDataHeader next = this.getReferHeader(); next != null; next = next.getReferHeader()) {
            lvs.add((String)data.get(next.getKey()));
        }
        int length = lvs.size();
        IMeta meta = this.getMeta();
        String metaName = meta != null ? meta.getName() : "";
        StringBuilder sb = new StringBuilder(metaName);
        for (int i = length - 1; i >= 0; --i) {
            sb.append("_").append(lvs.get(i));
        }
        return sb.toString();
    }
}

