/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.cell;

import jexx.poi.cell.AbstractCell;
import jexx.poi.cell.ICellSupportMeta;
import jexx.poi.cell.IMergedCell;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.row.Row;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.util.StringUtil;

public class MergedCell
extends AbstractCell
implements IMergedCell,
ICellSupportMeta {
    protected IMeta meta;
    protected boolean valid = true;
    protected ICellSupportMeta cellReference;

    public MergedCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        super(firstRowNum, firstColumnNum, lastRowNum, lastColumnNum, value, cellStyle);
    }

    public MergedCell(Row row, int firstColumnNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        super(row, firstColumnNum, lastColumnNum, value, cellStyle);
    }

    public MergedCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, Object value) {
        this(firstRowNum, firstColumnNum, lastRowNum, lastColumnNum, value, null);
    }

    public MergedCell(Row row, int firstColumnNum, int lastColumnNum, Object value) {
        this(row, firstColumnNum, lastColumnNum, value, null);
    }

    public MergedCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum) {
        this(firstRowNum, firstColumnNum, lastRowNum, lastColumnNum, null);
    }

    public MergedCell(Row row, int firstColumnNum, int lastColumnNum) {
        this(row, firstColumnNum, lastColumnNum, null);
    }

    public MergedCell(int firstRowNum, String firstColumnNo, int lastRowNum, String lastColumnNo, Object value, IWrapCellStyle cellStyle) {
        this(firstRowNum, CellOperateUtil.toColumnNum(firstColumnNo), lastRowNum, CellOperateUtil.toColumnNum(lastColumnNo), value, cellStyle);
    }

    public MergedCell(Row row, String firstColumnNo, String lastColumnNo, Object value, IWrapCellStyle cellStyle) {
        this(row, CellOperateUtil.toColumnNum(firstColumnNo), CellOperateUtil.toColumnNum(lastColumnNo), value, cellStyle);
    }

    public MergedCell(int firstRowNum, String firstColumnNo, int lastRowNum, String lastColumnNo, Object value) {
        this(firstRowNum, firstColumnNo, lastRowNum, lastColumnNo, value, null);
    }

    public MergedCell(Row row, String firstColumnNo, String lastColumnNo, Object value) {
        this(row, firstColumnNo, lastColumnNo, value, null);
    }

    public MergedCell(int firstRowNum, String firstColumnNo, int lastRowNum, String lastColumnNo) {
        this(firstRowNum, firstColumnNo, lastRowNum, lastColumnNo, null);
    }

    public MergedCell(Row row, String firstColumnNo, String lastColumnNo) {
        this(row, firstColumnNo, lastColumnNo, null);
    }

    @Override
    public Object getLabel() {
        if (!this.labelSet) {
            Object[] fullValues = this.getFullValues();
            Object[] labels = new Object[fullValues.length];
            for (int i = 0; i < fullValues.length; ++i) {
                if (this.supportMeta()) {
                    INode node = this.meta.getNodeByFullValue(fullValues[i]);
                    if (node == null) continue;
                    labels[i] = StringUtil.str((Object)node.getLabel());
                    continue;
                }
                labels[i] = fullValues[i];
            }
            Object label = labels.length == 0 ? null : (labels.length == 1 ? labels[0] : StringUtil.join((Object[])labels, (String)","));
            super.setLabel(label);
        }
        return super.getLabel();
    }

    @Override
    public void setLabel(Object label) {
        if (this.supportMeta()) {
            throw new UnsupportedOperationException("not support to set label");
        }
        super.setLabel(label);
    }

    @Override
    public boolean supportMeta() {
        return this.meta != null;
    }

    @Override
    public IMeta getMeta() {
        return this.meta;
    }

    public void setMeta(IMeta meta) {
        this.meta = meta;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void valid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public ICellSupportMeta getCellReference() {
        return this.cellReference;
    }

    @Override
    public void setCellReference(ICellSupportMeta cellReference) {
        this.cellReference = cellReference;
    }
}

