/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.io.File;
import java.io.InputStream;
import jexx.poi.AbstractExcel;
import jexx.poi.SheetReader;
import jexx.poi.exception.POIException;
import jexx.poi.meta.MetaSheetReader;
import jexx.poi.meta.Metas;
import jexx.poi.read.impl.SheetReaderImpl;
import jexx.poi.util.WorkbookUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
extends AbstractExcel {
    public ExcelReader(Workbook workbook) {
        this.workbook = workbook;
        this.loadMeta();
    }

    public ExcelReader(File excelFile) {
        this(WorkbookUtil.createBook(excelFile));
    }

    public ExcelReader(InputStream excelInputStream) {
        this(WorkbookUtil.createBook(excelInputStream));
    }

    private void loadMeta() {
        Sheet sheet = this.getSheet("__METADATA__");
        Metas meta = null;
        if (sheet != null) {
            MetaSheetReader reader = new MetaSheetReader(sheet);
            meta = reader.readMeta();
        }
        this.meta = meta;
    }

    public SheetReader sheet() {
        return this.sheet("Sheet1");
    }

    public SheetReader oneSheet() {
        Sheet sheet;
        int sheetNum = this.workbook.getNumberOfSheets();
        Sheet metaSheet = this.getSheet("__METADATA__");
        if (metaSheet != null) {
            if (--sheetNum != 1) {
                throw new POIException("there is not one sheet!");
            }
            int sheetIndex = this.workbook.getSheetIndex(metaSheet) == 0 ? 1 : 0;
            sheet = this.getSheetAt(sheetIndex + 1);
        } else {
            if (sheetNum != 1) {
                throw new POIException("there is not one sheet!");
            }
            sheet = this.getSheetAt(1);
        }
        return new SheetReaderImpl(sheet);
    }

    public SheetReader sheet(String sheetName) {
        if ("__METADATA__".equals(sheetName)) {
            return null;
        }
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new POIException("Sheet {} not exist!", sheetName);
        }
        return new SheetReaderImpl(sheet);
    }

    @Deprecated
    public SheetReader getSheet(int sheetNum) {
        String sheetName = this.workbook.getSheetName(sheetNum - 1);
        if ("__METADATA__".equals(sheetName)) {
            return null;
        }
        return this.sheet(sheetName);
    }

    public boolean matchVersion(String version) {
        if (StringUtil.isEmpty((CharSequence)version)) {
            throw new IllegalArgumentException("version is not illegal");
        }
        if (this.meta == null) {
            return false;
        }
        return version.equals(this.meta.getVersion());
    }
}

