/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.io.Closeable;
import jexx.io.IOUtil;
import jexx.poi.constant.SheetVisibilityEnum;
import jexx.poi.meta.Metas;
import jexx.util.Assert;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcel
implements Closeable {
    public static final String METADATA_SHEET_NAME = "__METADATA__";
    public static final String DEFAULT_SHEET_NAME = "Sheet1";
    protected Workbook workbook;
    protected Metas meta;

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    public boolean hasMetaSheet() {
        return this.workbook.getSheet(METADATA_SHEET_NAME) != null;
    }

    public Metas getMetas() {
        return this.meta;
    }

    public boolean hasSheet(String sheetName) {
        return this.workbook.getSheet(sheetName) != null;
    }

    protected Sheet getOrCreateSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(sheetName);
        }
        return sheet;
    }

    protected Sheet getSheet(String sheetName) {
        return this.workbook.getSheet(sheetName);
    }

    protected Sheet getSheetAt(int sheetNum) {
        return this.workbook.getSheetAt(sheetNum - 1);
    }

    public void setSheetVisibility(String sheetName, SheetVisibilityEnum visibility) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        if (sheetIndex > -1) {
            this.workbook.setSheetVisibility(sheetIndex, visibility.getVisibility());
        }
    }

    public void makeMetaSheetVisilble() {
        this.setSheetVisibility(METADATA_SHEET_NAME, SheetVisibilityEnum.VISIBLE);
    }

    public void setSheetOrder(String sheetName, int pos) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        Assert.notNull((Object)sheet, (String)"Sheet[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{sheetName});
        this.workbook.setSheetOrder(sheetName, pos);
    }

    @Override
    public void close() {
        IOUtil.closeQuietly((Closeable)this.workbook);
    }
}

