/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jexx.poi.cell.ICellSupportMeta;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowContext;
import jexx.poi.writer.AbstractRowWriter;
import jexx.poi.writer.RowWriter;
import jexx.util.StringUtil;

public class MapRowWriter
extends AbstractRowWriter
implements RowWriter<Map<String, Object>> {
    @Override
    public RowContext writeRow(int startRowNum, Map<String, Object> data, Headers headers, int itemIndex, boolean ignoreDataValid) {
        DataRow row = new DataRow(startRowNum);
        RowContext rowContext = new RowContext(row, headers.getHeaderRowContext());
        ArrayList<IDataHeader> cloneHeader = new ArrayList<IDataHeader>(headers.getDataHeaders());
        this.doRecursionHeader(cloneHeader, new HashMap<IDataHeader, Object>(), data, rowContext, itemIndex, ignoreDataValid);
        this.writeCustom(rowContext, headers, itemIndex);
        return rowContext;
    }

    protected void doRecursionHeader(List<IDataHeader> headerList, Map<IDataHeader, Object> checkMap, Map<String, Object> data, RowContext rowContext, int itemIndex, boolean ignoreDataValid) {
        int preSize = headerList.size();
        Iterator<IDataHeader> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            IDataHeader header = iterator.next();
            IDataHeader referHeader = header.getReferHeader();
            if (referHeader != null && checkMap.get(referHeader) == null) continue;
            Object value = data.get(header.getKey());
            if (header instanceof ICustomHeader) {
                value = ((ICustomHeader)((Object)header)).getCustomValue(rowContext.getRootRow(), itemIndex);
            }
            MergedCell cell = new MergedCell((Row)rowContext.getRootRow(), header.getStartColumnNum(), header.getStartColumnNum(), value, header.getDataCellStyle());
            cell.valid(!ignoreDataValid && header.isValid());
            cell.setMeta(header.getMeta());
            cell.setMultiValue(header.isMultiValue());
            rowContext.addCell(cell);
            if (referHeader != null) {
                IMergedCell referCell = rowContext.getCell(cell, referHeader.getStartColumnNum());
                assert (referCell != null);
                cell.setCellReference((ICellSupportMeta)((Object)referCell));
            }
            checkMap.put(header, new Object());
            iterator.remove();
        }
        int postSize = headerList.size();
        if (postSize > 0 && postSize == preSize) {
            String referKeys = StringUtil.join(headerList, (String)",", IDataHeader::getReferHeader);
            throw new IllegalArgumentException(StringUtil.format((String)"Please check the header column's referKey, referKeys=[{}] ", (Object[])new Object[]{referKeys}));
        }
        if (postSize > 0) {
            this.doRecursionHeader(headerList, checkMap, data, rowContext, itemIndex, ignoreDataValid);
        }
    }
}

