/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jexx.bean.DyBeanImpl;
import jexx.bean.IndexProperty;
import jexx.poi.cell.ICellSupportMeta;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.row.HeaderRow;
import jexx.poi.header.row.HeaderRowContext;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowContext;
import jexx.poi.util.HeaderPathUtil;
import jexx.poi.writer.AbstractRowWriter;
import jexx.poi.writer.RowTrigger;
import jexx.poi.writer.RowWriter;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public class IndexRowWriter
extends AbstractRowWriter
implements RowWriter<Object> {
    @Override
    public RowContext writeRow(int startRowNum, Object data, Headers headers, int itemIndex, boolean ignoreDataValid) {
        RowContext context = this.toRow(startRowNum, data, headers, itemIndex, ignoreDataValid);
        this.doRowTrigger(context, context.getRootRow(), headers);
        this.writeCustom(context, headers, itemIndex);
        return context;
    }

    protected RowContext toRow(int startRowNum, Object bean, Headers headers, int itemIndex, boolean ignoreDataValid) {
        DyBeanImpl dyBean = new DyBeanImpl();
        dyBean.setWrappedInstance(bean);
        ArrayList headerList = new ArrayList();
        HeaderRowContext headerRowContext = headers.getHeaderRowContext();
        List headerRows = headerRowContext.getHeaderRows().stream().sorted(Comparator.comparingInt(HeaderRow::getLevel)).collect(Collectors.toList());
        for (HeaderRow headerRow : headerRows) {
            headerRow.getHeaderMap().forEach((k, v) -> headerList.add(v));
        }
        HashMap<String, DataRow> rows = new HashMap<String, DataRow>(16);
        DataRow rootRow = new DataRow(startRowNum);
        RowContext rowContext = new RowContext(rootRow, headers.getHeaderRowContext());
        rows.put("", rootRow);
        this.doRecursionHeader(new ArrayList<IDataHeader>(headerList), new HashMap<IDataHeader, Object>(), rowContext, dyBean, rows, itemIndex, ignoreDataValid);
        return rowContext;
    }

    protected void doRecursionHeader(List<IDataHeader> headerList, Map<IDataHeader, Object> checkMap, RowContext rowContext, DyBeanImpl dyBean, Map<String, DataRow> rows, int itemIndex, boolean ignoreDataValid) {
        HeaderRowContext headerRowContext = rowContext.getHeaderRowContext();
        int preSize = headerList.size();
        Iterator<IDataHeader> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            IDataHeader header = iterator.next();
            IDataHeader referHeader = header.getReferHeader();
            if (referHeader != null && checkMap.get(referHeader) == null) continue;
            List indexProperties = dyBean.getIndexPropertyValues(header.getKey());
            for (IndexProperty indexProperty : indexProperties) {
                String key = indexProperty.getPath();
                Object value = indexProperty.getValue();
                List<String> paths = HeaderPathUtil.splitDataPaths(header.getKey(), key);
                paths.add(0, "");
                int pathSize = paths.size();
                String lastPath = paths.get(pathSize - 1);
                DataRow row = rows.get(lastPath);
                if (row == null) {
                    String path = paths.get(pathSize - 2);
                    DataRow parentRow = rows.get(path);
                    if (parentRow == null) {
                        throw new IllegalArgumentException("row[path={}] is null ");
                    }
                    row = rowContext.addDataRowAt(parentRow);
                    row.setParentRow(parentRow);
                    row.setPath(lastPath);
                    if (headerRowContext != null) {
                        row.setHeaderRow(headerRowContext.getHeaderRowByHeader(header));
                    }
                    rows.put(lastPath, row);
                }
                MergedCell cell = new MergedCell((Row)row, header.getStartColumnNum(), header.getStartColumnNum(), value, header.getDataCellStyle());
                cell.setMeta(header.getMeta());
                cell.valid(!ignoreDataValid && header.isValid());
                cell.setMultiValue(header.isMultiValue());
                rowContext.addCell(row, cell);
                if (referHeader == null) continue;
                IMergedCell referCell = row.getCellByColumnNum(referHeader.getStartColumnNum());
                assert (referCell != null);
                cell.setCellReference((ICellSupportMeta)((Object)referCell));
            }
            checkMap.put(header, new Object());
            iterator.remove();
        }
        int postSize = headerList.size();
        if (postSize > 0 && postSize == preSize) {
            String referKeys = StringUtil.join(headerList, (String)",", IDataHeader::getReferHeader);
            throw new IllegalArgumentException(StringUtil.format((String)"Please check the header column's referKey, referKeys=[{}] ", (Object[])new Object[]{referKeys}));
        }
        if (postSize > 0) {
            this.doRecursionHeader(headerList, checkMap, rowContext, dyBean, rows, itemIndex, ignoreDataValid);
        }
    }

    private void doRowTrigger(RowContext context, DataRow row, Headers headers) {
        List<IMergedCell> cells;
        List<Row> children = row.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (Row row1 : children) {
                if (!(row1 instanceof DataRow)) continue;
                this.doRowTrigger(context, (DataRow)row1, headers);
            }
        }
        if (CollectionUtil.isNotEmpty(cells = row.getCells())) {
            for (IMergedCell cell : cells) {
                List<RowTrigger> rowTriggers = headers.getRowTriggers(cell.getFirstColumnNum());
                if (!CollectionUtil.isNotEmpty(rowTriggers)) continue;
                for (RowTrigger trigger : rowTriggers) {
                    trigger.append(context, row);
                }
            }
        }
    }
}

