/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jexx.exception.IORuntimeException;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.poi.exception.POIException;
import jexx.poi.util.WorkbookUtil;
import jexx.poi.writer.AbstractExcelWriter;
import jexx.poi.writer.SheetBigWriter;
import jexx.poi.writer.impl.SheetBigWriterImpl;
import jexx.util.Assert;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelBigWriter
extends AbstractExcelWriter {
    protected List<SheetBigWriterImpl> sheetWriters = new ArrayList<SheetBigWriterImpl>();

    public ExcelBigWriter() {
        this(new XSSFWorkbook());
    }

    public ExcelBigWriter(XSSFWorkbook workbook) {
        super((Workbook)new SXSSFWorkbook(workbook), true, 0);
    }

    public static ExcelBigWriter createBigWriter() {
        return new ExcelBigWriter();
    }

    public static ExcelBigWriter createBigWriter(File file) {
        Workbook workbook = WorkbookUtil.createBook(file);
        if (!(workbook instanceof XSSFWorkbook)) {
            IOUtil.closeQuietly((Closeable)workbook);
            throw new POIException("don't support this file");
        }
        return new ExcelBigWriter((XSSFWorkbook)workbook);
    }

    public static ExcelBigWriter createBigWriter(InputStream inputStream) {
        Workbook workbook = WorkbookUtil.createBook(inputStream);
        if (!(workbook instanceof XSSFWorkbook)) {
            IOUtil.closeQuietly((Closeable)workbook);
            throw new POIException("don't support this stream");
        }
        return new ExcelBigWriter((XSSFWorkbook)workbook);
    }

    public SheetBigWriter sheet(String sheetName) {
        Assert.isTrue((!"__METADATA__".equalsIgnoreCase(sheetName) ? 1 : 0) != 0, (String)"Sheet name is not equal to {}", (Object[])new Object[]{sheetName});
        if (StringUtil.isEmpty((CharSequence)sheetName)) {
            sheetName = "Sheet1";
        }
        SXSSFSheet sheet = this.getOrCreateSheet(sheetName);
        SheetBigWriterImpl sheetWriter = new SheetBigWriterImpl(sheet);
        this.sheetWriters.add(sheetWriter);
        return sheetWriter;
    }

    protected SXSSFWorkbook getWorkbook() {
        return (SXSSFWorkbook)this.workbook;
    }

    protected SXSSFSheet getOrCreateSheet(String sheetName) {
        SXSSFSheet sheet = this.getWorkbook().getSheet(sheetName);
        if (sheet == null) {
            sheet = this.getWorkbook().createSheet(sheetName);
        }
        return sheet;
    }

    public ExcelBigWriter flush(OutputStream out) {
        try {
            this.flushSheets();
            this.workbook.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public ExcelBigWriter flush(File destFile) {
        BufferedOutputStream out = null;
        try {
            out = FileUtil.newBufferedOutputStream((File)destFile);
            this.flush(out);
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
        return this;
    }

    private void flushSheets() {
        for (SheetBigWriterImpl sheetBigWriter : this.sheetWriters) {
            sheetBigWriter.flush();
        }
    }
}

