/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.io.FileUtil;
import jexx.poi.constant.PictureType;
import jexx.poi.header.Headers;
import jexx.poi.header.IHeader;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.style.StyleUtil;
import jexx.poi.style.WrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.RowOperationUtil;
import jexx.poi.util.SheetUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.RegionUtil;

public abstract class AbstractSheetWriter {
    protected Sheet sheet;
    protected DataFormat dataFormat;
    protected FormulaEvaluator formulaEvaluator;
    @Deprecated
    protected boolean supportTrimData = false;

    public AbstractSheetWriter(Sheet sheet) {
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public void insertRows(int startRowNum, int rowNum) {
        Row lastRow;
        Assert.isTrue((startRowNum > 1 ? 1 : 0) != 0, (String)"startRowNum must be greater than 1", (Object[])new Object[0]);
        int lastRowIndexOfSheet = this.sheet.getLastRowNum();
        Assert.isTrue((lastRowIndexOfSheet > 0 ? 1 : 0) != 0, (String)"Sheet[{}] has no row", (Object[])new Object[]{this.sheet.getSheetName()});
        this.sheet.shiftRows(startRowNum - 1, lastRowIndexOfSheet, rowNum, true, false);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<CellRangeAddress> cellRangeAddresses = new ArrayList<CellRangeAddress>();
        List cellRangeAddressList = this.sheet.getMergedRegions();
        int startRowIndex = startRowNum - 1;
        int lastRowIndex = startRowIndex - 1;
        for (int i = 0; i < cellRangeAddressList.size(); ++i) {
            CellRangeAddress cellRangeAddress = this.sheet.getMergedRegion(i);
            if (startRowIndex >= cellRangeAddress.getFirstRow() && startRowIndex <= cellRangeAddress.getLastRow()) {
                cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() + rowNum);
                indices.add(i);
                cellRangeAddresses.add(cellRangeAddress);
            }
            if (lastRowIndex != cellRangeAddress.getFirstRow() || lastRowIndex != cellRangeAddress.getLastRow()) continue;
            for (int j = 0; j < rowNum; ++j) {
                CellRangeAddress newCellRangeAddress = new CellRangeAddress(startRowNum + j - 1, startRowNum + j - 1, cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
                cellRangeAddresses.add(newCellRangeAddress);
            }
        }
        if (CollectionUtil.isNotEmpty(indices)) {
            this.sheet.removeMergedRegions(indices);
        }
        if (CollectionUtil.isNotEmpty(cellRangeAddresses)) {
            for (CellRangeAddress cellRangeAddress : cellRangeAddresses) {
                this.sheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            this.sheet.validateMergedRegions();
        }
        if ((lastRow = this.sheet.getRow(lastRowIndex)) == null) {
            return;
        }
        for (int i = startRowNum; i < startRowNum + rowNum; ++i) {
            Row row = this.getOrCreateRow(i);
            row.setHeight(lastRow.getHeight());
            for (short j = 0; j <= lastRow.getLastCellNum(); j = (short)(j + 1)) {
                Cell lastCell = lastRow.getCell((int)j);
                if (lastCell == null) continue;
                Cell cell = this.getOrCreateCell(row, j + 1);
                cell.setCellStyle(lastCell.getCellStyle());
            }
        }
    }

    public void setSupportTrimData(boolean supportTrimData) {
        this.supportTrimData = supportTrimData;
    }

    protected int addPicture(int row1Num, int col1Num, int row2Num, int col2Num, byte[] imgBuffer, PictureType pictureType) {
        Assert.isTrue((row1Num > 0 ? 1 : 0) != 0, (String)"row1Num must be greater than 0", (Object[])new Object[0]);
        Assert.isTrue((col1Num > 0 ? 1 : 0) != 0, (String)"col1Num must be greater than 0", (Object[])new Object[0]);
        Assert.isTrue((row2Num > 0 ? 1 : 0) != 0, (String)"row2Num must be greater than 0", (Object[])new Object[0]);
        Assert.isTrue((col2Num > 0 ? 1 : 0) != 0, (String)"col2Num must be greater than 0", (Object[])new Object[0]);
        Drawing drawing = this.sheet.getDrawingPatriarch();
        if (drawing == null) {
            drawing = this.sheet.createDrawingPatriarch();
        }
        CreationHelper helper = this.sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setRow1(row1Num - 1);
        anchor.setCol1(col1Num - 1);
        anchor.setRow2(row2Num);
        anchor.setCol2(col2Num);
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        int pictureIdx = this.sheet.getWorkbook().addPicture(imgBuffer, pictureType.getType());
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        pict.resize(1.0, 1.0);
        return pictureIdx;
    }

    protected int addPicture(int row1Num, String col1No, int row2Num, String col2No, byte[] imgBuffer, PictureType pictureType) {
        return this.addPicture(row1Num, CellOperateUtil.toColumnNum(col1No), row2Num, CellOperateUtil.toColumnNum(col2No), imgBuffer, pictureType);
    }

    protected int addPicture(int rowNum, int colNum, byte[] imgBuffer, PictureType pictureType) {
        return this.addPicture(rowNum, colNum, rowNum, colNum, imgBuffer, pictureType);
    }

    protected int addPicture(int rowNum, String colNo, byte[] imgBuffer, PictureType pictureType) {
        return this.addPicture(rowNum, CellOperateUtil.toColumnNum(colNo), imgBuffer, pictureType);
    }

    protected int addPicture(int row1Num, int col1Num, int row2Num, int col2Num, File imageFile, PictureType pictureType) {
        byte[] imgBuffer = FileUtil.read((File)imageFile);
        return this.addPicture(row1Num, col1Num, row2Num, col2Num, imgBuffer, pictureType);
    }

    protected int addPicture(int row1Num, String col1No, int row2Num, String col2No, File imageFile, PictureType pictureType) {
        byte[] imgBuffer = FileUtil.read((File)imageFile);
        return this.addPicture(row1Num, CellOperateUtil.toColumnNum(col1No), row2Num, CellOperateUtil.toColumnNum(col2No), imgBuffer, pictureType);
    }

    protected int addPicture(int rowNum, int colNum, File imageFile, PictureType pictureType) {
        byte[] imgBuffer = FileUtil.read((File)imageFile);
        return this.addPicture(rowNum, colNum, imgBuffer, pictureType);
    }

    protected int addPicture(int rowNum, String colNo, File imageFile, PictureType pictureType) {
        return this.addPicture(rowNum, CellOperateUtil.toColumnNum(colNo), imageFile, pictureType);
    }

    protected int addPicture(int rowNum, int colNum, File imageFile) {
        PictureType pictureType = PictureType.checkType(imageFile.getName());
        if (pictureType == null) {
            pictureType = PictureType.PNG;
        }
        return this.addPicture(rowNum, colNum, imageFile, pictureType);
    }

    protected int addPicture(int rowNum, String colNo, File imageFile) {
        return this.addPicture(rowNum, CellOperateUtil.toColumnNum(colNo), imageFile);
    }

    public void autoSizeColumn(int ... columnNums) {
        for (int columnNum : columnNums) {
            double width = SheetUtil.getColumnWidth(this.sheet, columnNum, true);
            if (width == -1.0) continue;
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(columnNum, (int)width);
        }
    }

    public void autoSizeColumn(Headers headers) {
        List<IHeader> headerList = headers.getHeaders();
        for (IHeader header : headerList) {
            this.autoSizeColumn(header.getStartColumnNum());
        }
    }

    public void autoSizeColumnWithMaxColumnNum(int maxColumnNum) {
        int i = 1;
        while (i <= maxColumnNum) {
            this.autoSizeColumn(i++);
        }
    }

    public void setColumnWidth(int columnNum, int width) {
        this.sheet.setColumnWidth(columnNum - 1, width);
    }

    @Deprecated
    public void evaluateFormulaCell() {
        this.sheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluateAll();
    }

    protected Map<String, Object> getFormatProperties(IWrapCellStyle cellStyle) {
        HashMap<String, Object> properties = new HashMap<String, Object>(25);
        properties.put("alignment", cellStyle.getAlignment());
        properties.put("verticalAlignment", cellStyle.getVerticalAlignment());
        properties.put("borderBottom", cellStyle.getBottomBorderStyle());
        properties.put("borderLeft", cellStyle.getLeftBorderStyle());
        properties.put("borderRight", cellStyle.getRightBorderStyle());
        properties.put("borderTop", cellStyle.getTopBorderStyle());
        IndexedColors bottomBorderColor = cellStyle.getBottomBorderColor();
        properties.put("bottomBorderColor", bottomBorderColor != null ? Short.valueOf(bottomBorderColor.getIndex()) : null);
        IndexedColors leftBorderColor = cellStyle.getLeftBorderColor();
        properties.put("leftBorderColor", leftBorderColor != null ? Short.valueOf(leftBorderColor.getIndex()) : null);
        IndexedColors rightBorderColor = cellStyle.getRightBorderColor();
        properties.put("rightBorderColor", rightBorderColor != null ? Short.valueOf(rightBorderColor.getIndex()) : null);
        IndexedColors topBorderColor = cellStyle.getTopBorderColor();
        properties.put("topBorderColor", topBorderColor != null ? Short.valueOf(topBorderColor.getIndex()) : null);
        properties.put("fillPattern", cellStyle.getFillPattern());
        IndexedColors fillForegroundColor = cellStyle.getFillForegroundColor();
        properties.put("fillForegroundColor", fillForegroundColor != null ? fillForegroundColor.getIndex() : (short)0);
        IndexedColors fillBackgroundColor = cellStyle.getFillBackgroundColor();
        properties.put("fillBackgroundColor", fillBackgroundColor != null ? fillBackgroundColor.getIndex() : (short)0);
        properties.put("hidden", cellStyle.isHidden());
        properties.put("locked", cellStyle.isLocked());
        properties.put("indention", cellStyle.getIndent());
        properties.put("rotation", cellStyle.getRotation());
        properties.put("wrapText", cellStyle.isWrapped());
        properties.put("font", 0);
        if (StringUtil.isNotEmpty((CharSequence)cellStyle.getDataFormat())) {
            properties.put("dataFormat", this.getDataFormat().getFormat(cellStyle.getDataFormat()));
        }
        return properties;
    }

    protected void setCellStyle(Cell cell, IWrapCellStyle cellStyle) {
        CellUtil.setCellStyleProperties((Cell)cell, this.getFormatProperties(cellStyle));
    }

    protected void setCellStyle(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, IWrapCellStyle cellStyle) {
        if (cellStyle == null) {
            return;
        }
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRowNum - 1, lastRowNum - 1, firstColumnNum - 1, lastColumnNum - 1);
        this.setCellStyle(cellRangeAddress, cellStyle);
    }

    protected void setCellStyle(CellRangeAddress cellRangeAddress, IWrapCellStyle cellStyle) {
        int firstRowNum = cellRangeAddress.getFirstRow() + 1;
        int firstColumnNum = cellRangeAddress.getFirstColumn() + 1;
        int lastRowNum = cellRangeAddress.getLastRow() + 1;
        int lastColumnNum = cellRangeAddress.getLastColumn() + 1;
        Row row = RowOperationUtil.getRow(this.sheet, firstRowNum);
        Cell cell = CellOperateUtil.getCell(row, firstColumnNum);
        this.setCellStyle(cell, cellStyle);
        if (lastRowNum > firstRowNum || lastColumnNum > firstColumnNum) {
            if (cellStyle.getLeftBorderStyle() != null) {
                RegionUtil.setBorderLeft((BorderStyle)cellStyle.getLeftBorderStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getLeftBorderColor() != null) {
                RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor().index, (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getTopBorderStyle() != null) {
                RegionUtil.setBorderTop((BorderStyle)cellStyle.getTopBorderStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getTopBorderColor() != null) {
                RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor().index, (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getRightBorderStyle() != null) {
                RegionUtil.setBorderRight((BorderStyle)cellStyle.getRightBorderStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getRightBorderColor() != null) {
                RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor().index, (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getBottomBorderStyle() != null) {
                RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBottomBorderStyle(), (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
            if (cellStyle.getBottomBorderColor() != null) {
                RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor().index, (CellRangeAddress)cellRangeAddress, (Sheet)this.sheet);
            }
        }
    }

    public IWrapCellStyle getCellStyle(int rowNum, int columnNum) {
        Row row = RowOperationUtil.getRow(this.sheet, rowNum);
        Cell cell = CellOperateUtil.getCell(row, columnNum);
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            return null;
        }
        WrapCellStyle wrapCellStyle = new WrapCellStyle();
        wrapCellStyle.setAlignment(cellStyle.getAlignmentEnum());
        wrapCellStyle.setVerticalAlignment(cellStyle.getVerticalAlignmentEnum());
        wrapCellStyle.setBottomBorderStyle(cellStyle.getBorderBottomEnum());
        wrapCellStyle.setLeftBorderStyle(cellStyle.getBorderLeftEnum());
        wrapCellStyle.setRightBorderStyle(cellStyle.getBorderRightEnum());
        wrapCellStyle.setTopBorderStyle(cellStyle.getBorderTopEnum());
        wrapCellStyle.setBottomBorderColor(IndexedColors.fromInt((int)cellStyle.getBottomBorderColor()));
        wrapCellStyle.setLeftBorderColor(IndexedColors.fromInt((int)cellStyle.getLeftBorderColor()));
        wrapCellStyle.setRightBorderColor(IndexedColors.fromInt((int)cellStyle.getRightBorderColor()));
        wrapCellStyle.setTopBorderColor(IndexedColors.fromInt((int)cellStyle.getTopBorderColor()));
        wrapCellStyle.setFillPattern(cellStyle.getFillPatternEnum());
        wrapCellStyle.setFillBackgroundColor(IndexedColors.fromInt((int)cellStyle.getFillBackgroundColor()));
        wrapCellStyle.setFillBackgroundColor(IndexedColors.fromInt((int)cellStyle.getFillForegroundColor()));
        wrapCellStyle.setHidden(cellStyle.getHidden());
        wrapCellStyle.setLocked(cellStyle.getLocked());
        wrapCellStyle.setIndent(cellStyle.getIndention());
        wrapCellStyle.setRotation(cellStyle.getRotation());
        wrapCellStyle.setWrapped(cellStyle.getWrapText());
        wrapCellStyle.setDataFormat(this.getDataFormat().getFormat(cellStyle.getDataFormat()));
        return wrapCellStyle;
    }

    protected Row getOrCreateRow(int rowNum) {
        Assert.isTrue((rowNum > 0 ? 1 : 0) != 0);
        return RowOperationUtil.getRow(this.sheet, rowNum);
    }

    protected Cell getOrCreateCell(Row row, int columnNum) {
        Assert.isTrue((columnNum > 0 ? 1 : 0) != 0, (String)"columnNum={}", (Object[])new Object[]{columnNum});
        return CellOperateUtil.getCell(row, columnNum);
    }

    protected void setCellValue(Cell cell, Object value) {
        Object newValue = value;
        if (this.supportTrimData && newValue instanceof String) {
            newValue = StringUtil.trim((String)newValue.toString());
        }
        CellOperateUtil.setCellValue(cell, newValue);
    }

    protected CellStyle getCellStyle(Cell cell) {
        CellStyle cellStyle = StyleUtil.createCellStyle(this.sheet.getWorkbook());
        if (cell.getCellStyle() != null) {
            cellStyle.cloneStyleFrom(cell.getCellStyle());
        }
        return cellStyle;
    }

    protected CellStyle createCellStyle(Cell cell) {
        CellStyle cellStyle = StyleUtil.createCellStyle(this.sheet.getWorkbook());
        if (cell.getCellStyle() != null) {
            cellStyle.cloneStyleFrom(cell.getCellStyle());
        }
        return cellStyle;
    }

    protected DataFormat getDataFormat() {
        if (this.dataFormat == null) {
            this.dataFormat = this.sheet.getWorkbook().createDataFormat();
        }
        assert (this.dataFormat != null);
        return this.dataFormat;
    }

    protected CellValue evaluate(Cell cell) {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }
        return this.formulaEvaluator.evaluate(cell);
    }
}

