/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jexx.bean.BeanUtil;
import jexx.bean.DyBean;
import jexx.bean.DyBeanFactory;
import jexx.poi.RowMapper;
import jexx.poi.SheetReader;
import jexx.poi.cell.ICell;
import jexx.poi.cell.IMergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.read.MapRowMapper;
import jexx.poi.read.SheetCellReader;
import jexx.poi.row.RowActionPredicate;
import jexx.poi.row.RowScanAction;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetReaderImpl
extends SheetCellReader
implements SheetReader {
    private static final Logger LOG = LoggerFactory.getLogger(SheetReaderImpl.class);
    private boolean skipEmptyRow = false;
    @Deprecated
    protected boolean supportTrimData = false;
    protected boolean simpleBean = true;

    public SheetReaderImpl(Sheet sheet) {
        super(sheet);
    }

    @Override
    public SheetReaderImpl setSkipEmptyRow(boolean skipEmptyRow) {
        this.skipEmptyRow = skipEmptyRow;
        return this;
    }

    @Override
    public SheetReaderImpl setSupportTrimData(boolean supportTrimData) {
        this.supportTrimData = supportTrimData;
        return this;
    }

    @Override
    public SheetReader setIsSimpleBean(boolean isSimpleBean) {
        this.simpleBean = isSimpleBean;
        return this;
    }

    @Override
    public SheetReaderImpl passCurrentRow() {
        this.skipRows(1);
        return this;
    }

    @Override
    public SheetReaderImpl skipRows(int skipRowSize) {
        this.doSkipRow(skipRowSize);
        return this;
    }

    @Override
    public SheetReaderImpl jumpToRowNum(int rowNum) {
        Assert.isTrue((rowNum > 0 ? 1 : 0) != 0, (String)"rowNum is not illegal", (Object[])new Object[0]);
        this.doJumpToRow(rowNum);
        return this;
    }

    protected <T> T readRow(Row row, int startColumnNum, int endColumnNum, RowMapper<T> rowMapper) {
        int rowNum = row.getRowNum();
        int minColumnNum = Math.max(1, startColumnNum);
        int lastCellNum = this.getLastCellNumAtOneRow(row);
        if (lastCellNum == -1) {
            return null;
        }
        int maxColumnNum = Math.min(lastCellNum, endColumnNum);
        List<IMergedCell> cells = this.readCellsAtOneRow(row, minColumnNum, maxColumnNum);
        return rowMapper.mapRow(cells, rowNum);
    }

    protected <T> T readRowAndNext(Row row, int startColumnNum, int endColumnNum, RowMapper<T> rowMapper) {
        T t = this.readRow(row, startColumnNum, endColumnNum, rowMapper);
        this.doNextRowIfHasNext();
        return t;
    }

    protected <T> T readRow(Row row, RowMapper<T> rowMapper) {
        int rowNum = row.getRowNum();
        int minColumnNum = 1;
        int lastCellNum = this.getLastCellNumAtOneRow(row);
        if (lastCellNum == -1) {
            return null;
        }
        List<IMergedCell> cells = this.readCellsAtOneRow(row, minColumnNum, lastCellNum);
        return rowMapper.mapRow(cells, rowNum);
    }

    protected <T> T readRowAndNext(Row row, RowMapper<T> rowMapper) {
        T t = this.readRow(row, rowMapper);
        this.doNextRowIfHasNext();
        return t;
    }

    protected <T> List<T> readRows(int lastRowNum, int startColumnNum, int endColumnNum, RowMapper<T> rowMapper, RowActionPredicate<T> skipRow) {
        ArrayList<T> list = new ArrayList<T>();
        if (this.getCurrentRowNum() > lastRowNum) {
            return list;
        }
        int currentRowNum = this.getCurrentRowNum();
        int minColumnNum = Math.max(1, startColumnNum);
        while (currentRowNum <= lastRowNum) {
            int lastCellNum;
            Row row = this.getCurrentRow();
            List<IMergedCell> cells = this.readCellsAtOneRow(row, minColumnNum, Math.min(lastCellNum = this.getLastCellNumAtOneRow(row), endColumnNum));
            T t = rowMapper.mapRow(cells, currentRowNum);
            if (t != null) {
                if (skipRow == null) {
                    list.add(t);
                } else {
                    RowScanAction action = skipRow.action(t, currentRowNum);
                    if (RowScanAction.STOP == action) break;
                    if (RowScanAction.KEEP_AND_STOP == action) {
                        list.add(t);
                        break;
                    }
                    list.add(t);
                }
            }
            if (!this.hasNextRow()) break;
            this.doNextRow();
            currentRowNum = this.getCurrentRowNum();
        }
        return list;
    }

    protected <T> List<T> readRowsAndNext(int lastRowNum, int startColumnNum, int endColumnNum, RowMapper<T> rowMapper, RowActionPredicate<T> skipRow) {
        List<T> list = this.readRows(lastRowNum, startColumnNum, endColumnNum, rowMapper, skipRow);
        this.doNextRowIfHasNext();
        return list;
    }

    @Override
    public <T> T readRowAndNext(int startColumnNum, int endColumnNum, RowMapper<T> rowMapper) {
        Assert.isTrue((endColumnNum >= startColumnNum ? 1 : 0) != 0, (String)"endColumnNum[{}] must be equal or greater than startColumnNum[{}]", (Object[])new Object[]{startColumnNum, endColumnNum});
        Row row = this.getCurrentRow();
        return this.readRowAndNext(row, startColumnNum, endColumnNum, rowMapper);
    }

    @Override
    public <T> T readRowAndNext(RowMapper<T> rowMapper) {
        Row row = this.getCurrentRow();
        return this.readRowAndNext(row, rowMapper);
    }

    @Override
    public <T> List<T> readRowsAndNext(int lastRowNum, RowMapper<T> rowMapper, boolean includeNull) {
        ArrayList<T> list = new ArrayList<T>();
        int currentRowNum = this.getCurrentRowNum();
        if (currentRowNum > lastRowNum) {
            return list;
        }
        while (currentRowNum <= lastRowNum) {
            T t = this.readRowAndNext(this.getCurrentRow(), rowMapper);
            if (t != null || includeNull) {
                list.add(t);
            }
            if (!this.hasNextRow()) break;
            currentRowNum = this.getCurrentRowNum();
        }
        return list;
    }

    @Override
    public <T> List<T> readRowsAndNext(RowMapper<T> rowMapper, boolean includeNull) {
        return this.readRowsAndNext(Integer.MAX_VALUE, rowMapper, includeNull);
    }

    @Override
    public <T> List<T> readRowsAndNext(RowMapper<T> rowMapper) {
        return this.readRowsAndNext(rowMapper, false);
    }

    @Override
    public List<Object> readListRowAndNext(int startColumnNum, int endColumnNum) {
        Assert.isTrue((startColumnNum > 0 && endColumnNum >= startColumnNum ? 1 : 0) != 0, (String)"startColumnNum={},endColumnNum={}", (Object[])new Object[]{startColumnNum, endColumnNum});
        return this.readRowAndNext(startColumnNum, endColumnNum, (rowData, rowNum) -> rowData.stream().map(ICell::getValue).collect(Collectors.toList()));
    }

    @Override
    public List<Object> readListRowAndNext(int startColumnNum) {
        return this.readListRowAndNext(startColumnNum, this.getLastCellNumOfCurrentRow());
    }

    @Override
    public List<Object> readListRowAndNext() {
        return this.readListRowAndNext(1);
    }

    @Override
    public List<List<Object>> readListRowsAndNext(int lastRowNum, int startColumnNum, int endColumnNum) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        int currentRowNum = this.getCurrentRowNum();
        if (currentRowNum > lastRowNum) {
            return list;
        }
        while (currentRowNum <= lastRowNum) {
            List t = this.readRowAndNext(this.getCurrentRow(), (rowData, rowNum) -> rowData.stream().map(ICell::getValue).collect(Collectors.toList()));
            if (t != null) {
                list.add(t);
            }
            if (!this.hasNextRow()) break;
            currentRowNum = this.getCurrentRowNum();
        }
        return list;
    }

    @Override
    public List<List<Object>> readListRowsAndNext(int startColumnNum, int endColumnNum) {
        return this.readListRowsAndNext(Integer.MAX_VALUE, startColumnNum, endColumnNum);
    }

    @Override
    public List<List<Object>> readListRowsAndNext(int startColumnNum) {
        int lastCellNum = this.getLastCellNumOfCurrentRow();
        return this.readListRowsAndNext(startColumnNum, lastCellNum);
    }

    @Override
    public List<List<Object>> readListRowsAndNext() {
        return this.readListRowsAndNext(1);
    }

    @Override
    public Map<String, Object> readMapRowAndNext(Headers headers) {
        Assert.isTrue((headers != null && CollectionUtil.isNotEmpty(headers.getHeaders()) ? 1 : 0) != 0, (String)"headers not empty", (Object[])new Object[0]);
        int minHeaderNum = 0;
        int maxHeaderNum = 0;
        for (IDataHeader dataHeader : headers.getDataHeaders()) {
            if (minHeaderNum == 0) {
                minHeaderNum = dataHeader.getStartColumnNum();
                maxHeaderNum = dataHeader.getStartColumnNum();
                continue;
            }
            minHeaderNum = Math.min(minHeaderNum, dataHeader.getStartColumnNum());
            maxHeaderNum = Math.max(maxHeaderNum, dataHeader.getStartColumnNum());
        }
        Row row = this.getCurrentRow();
        return this.readRowAndNext(row, minHeaderNum, maxHeaderNum, new MapRowMapper(headers, this.supportTrimData, this.skipEmptyRow));
    }

    @Override
    public List<Map<String, Object>> readMapRowsAndNext(int lastRowNum, Headers headers) {
        Assert.isTrue((headers != null && CollectionUtil.isNotEmpty(headers.getHeaders()) ? 1 : 0) != 0, (String)"headers not empty", (Object[])new Object[0]);
        int minHeaderNum = 0;
        int maxHeaderNum = 0;
        for (IDataHeader dataHeader : headers.getDataHeaders()) {
            if (minHeaderNum == 0) {
                minHeaderNum = dataHeader.getStartColumnNum();
                maxHeaderNum = dataHeader.getStartColumnNum();
                continue;
            }
            minHeaderNum = Math.min(minHeaderNum, dataHeader.getStartColumnNum());
            maxHeaderNum = Math.max(maxHeaderNum, dataHeader.getStartColumnNum());
        }
        return this.readRowsAndNext(lastRowNum, minHeaderNum, maxHeaderNum, new MapRowMapper(headers, this.supportTrimData, this.skipEmptyRow), null);
    }

    @Override
    public List<Map<String, Object>> readMapRowsAndNext(Headers headers) {
        return this.readMapRowsAndNext(Integer.MAX_VALUE, headers);
    }

    @Override
    public <T> T readBeanRowAndNext(Class<T> clazz, Headers headers) {
        Map<String, Object> map = this.readMapRowAndNext(headers);
        return (T)BeanUtil.toBean(clazz, map);
    }

    @Override
    public <T> List<T> readBeanRowsAndNext(int lastRowNum, Class<T> clazz, Headers headers, RowActionPredicate<T> skipRow) {
        int minHeaderNum = 0;
        int maxHeaderNum = 0;
        for (IDataHeader dataHeader : headers.getDataHeaders()) {
            if (minHeaderNum == 0) {
                minHeaderNum = dataHeader.getStartColumnNum();
                maxHeaderNum = dataHeader.getStartColumnNum();
                continue;
            }
            minHeaderNum = Math.min(minHeaderNum, dataHeader.getStartColumnNum());
            maxHeaderNum = Math.max(maxHeaderNum, dataHeader.getStartColumnNum());
        }
        MapRowMapper rowMapper = new MapRowMapper(headers, this.supportTrimData, this.skipEmptyRow);
        return this.readRowsAndNext(lastRowNum, minHeaderNum, maxHeaderNum, (cells, rowNum) -> {
            Object t;
            Object map = rowMapper.mapRow(cells, rowNum);
            if (map == null) {
                return null;
            }
            if (this.simpleBean) {
                t = BeanUtil.toBean((Class)clazz, (Map)map);
            } else {
                t = ReflectUtil.newInstance((Class)clazz, (Object[])new Object[0]);
                DyBean dyBean = DyBeanFactory.createDyBean((Object)t, (boolean)true, (boolean)true);
                map.forEach((arg_0, arg_1) -> ((DyBean)dyBean).setPropertyValue(arg_0, arg_1));
            }
            return t;
        }, skipRow);
    }

    @Override
    public <T> List<T> readBeanRowsAndNext(Class<T> clazz, Headers headers, RowActionPredicate<T> skipRow) {
        return this.readBeanRowsAndNext(Integer.MAX_VALUE, clazz, headers, skipRow);
    }

    @Override
    public <T> List<T> readBeanRowsAndNext(Class<T> clazz, Headers headers) {
        return this.readBeanRowsAndNext(clazz, headers, null);
    }

    @Override
    public boolean validateHeaders(Headers headers) {
        if (CollectionUtil.isEmpty(headers.getDataHeaders())) {
            return false;
        }
        List<IMergedCell> cells = this.readCellsAtOneRow(this.getCurrentRow());
        if (CollectionUtil.isEmpty(cells)) {
            return false;
        }
        Map<Integer, Object> map = cells.stream().filter(s -> s.getValue() != null).collect(Collectors.toMap(ICell::getFirstColumnNum, ICell::getValue));
        for (IDataHeader header : headers.getDataHeaders()) {
            String mapValue = (String)map.get(header.getStartColumnNum());
            if (header.getValue().equals(mapValue)) continue;
            LOG.warn("validate header[{}] failed, now is \"{}\"!", (Object)header.getValue(), (Object)mapValue);
            return false;
        }
        return true;
    }

    protected int getLastCellNumOfCurrentRow() {
        return this.getLastCellNumAtOneRow(this.getCurrentRow());
    }
}

