/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read;

import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class DelegateRow
implements Row {
    private static final Iterator<Cell> EMPTY = new Iterator<Cell>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Cell next() {
            return null;
        }
    };
    private final Row row;
    private final int rowNum;

    public DelegateRow(Row row) {
        this.row = row;
        this.rowNum = row.getRowNum();
    }

    public DelegateRow(int rowNum) {
        this.row = null;
        this.rowNum = rowNum;
    }

    public Row getDelegate() {
        return this.row;
    }

    public Cell createCell(int column) {
        throw new UnsupportedOperationException();
    }

    public Cell createCell(int column, int type) {
        throw new UnsupportedOperationException();
    }

    public Cell createCell(int column, CellType type) {
        throw new UnsupportedOperationException();
    }

    public void removeCell(Cell cell) {
        throw new UnsupportedOperationException();
    }

    public void setRowNum(int rowNum) {
        throw new UnsupportedOperationException();
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public Cell getCell(int cellnum) {
        return this.row != null ? this.row.getCell(cellnum) : null;
    }

    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        return this.row != null ? this.row.getCell(cellnum, policy) : null;
    }

    public short getFirstCellNum() {
        return this.row != null ? this.row.getFirstCellNum() : (short)-1;
    }

    public short getLastCellNum() {
        return this.row != null ? this.row.getLastCellNum() : (short)-1;
    }

    public int getPhysicalNumberOfCells() {
        return this.row != null ? this.row.getPhysicalNumberOfCells() : 0;
    }

    public void setHeight(short height) {
        if (this.row != null) {
            this.row.setHeight(height);
        }
    }

    public void setZeroHeight(boolean zHeight) {
        if (this.row != null) {
            this.row.setZeroHeight(zHeight);
        }
    }

    public boolean getZeroHeight() {
        return this.row != null && this.row.getZeroHeight();
    }

    public void setHeightInPoints(float height) {
        if (this.row != null) {
            this.row.setHeightInPoints(height);
        }
    }

    public short getHeight() {
        return this.row != null ? this.row.getHeight() : (short)0;
    }

    public float getHeightInPoints() {
        return this.row != null ? this.row.getHeightInPoints() : 0.0f;
    }

    public boolean isFormatted() {
        return this.row != null && this.row.isFormatted();
    }

    public CellStyle getRowStyle() {
        return this.row != null ? this.row.getRowStyle() : null;
    }

    public void setRowStyle(CellStyle style) {
        if (this.row != null) {
            this.row.setRowStyle(style);
        }
    }

    public Iterator<Cell> cellIterator() {
        return this.row != null ? this.row.cellIterator() : null;
    }

    public Sheet getSheet() {
        throw new UnsupportedOperationException();
    }

    public int getOutlineLevel() {
        return this.row != null ? this.row.getOutlineLevel() : 0;
    }

    public Iterator<Cell> iterator() {
        return this.row != null ? this.row.iterator() : EMPTY;
    }
}

