/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.header.Headers;
import jexx.poi.meta.IMeta;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.MapUtil;

public class Metas {
    public static final String META_VERSION = "META_VERSION";
    public static final String META_CREATE_TIME = "META_CREATE_TIME";
    private String version;
    private Date createTime;
    private final Map<String, String> customProperties;
    private final Map<String, IMeta> metaMap = new HashMap<String, IMeta>(16);
    private final Map<String, Headers> headersMap = new HashMap<String, Headers>(16);

    public Metas() {
        this("");
    }

    public Metas(String version) {
        this.version = version;
        this.createTime = new Date();
        this.customProperties = new HashMap<String, String>(4);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Map<String, String> getCustomProperties() {
        return Collections.unmodifiableMap(this.customProperties);
    }

    public void addProperty(String key, String value) {
        if (META_VERSION.equals(key) || META_CREATE_TIME.equals(key)) {
            throw new IllegalArgumentException("cannot use property " + key);
        }
        this.customProperties.put(key, value);
    }

    public void addProperty(Map<String, String> properties) {
        if (CollectionUtil.isNotEmpty(properties)) {
            properties.forEach(this::addProperty);
        }
    }

    public void removeProperty(String key) {
        if (META_VERSION.equals(key) || META_CREATE_TIME.equals(key)) {
            throw new IllegalArgumentException("cannot remove property " + key);
        }
        this.customProperties.remove(key);
    }

    public String getProperty(String key) {
        if (META_VERSION.equals(key) || META_CREATE_TIME.equals(key)) {
            throw new IllegalArgumentException("cannot remove property " + key);
        }
        return this.customProperties.get(key);
    }

    public Metas addMeta(IMeta meta) {
        Assert.hasText((String)meta.getName(), (String)"Meta's label is not empty!", (Object[])new Object[0]);
        Assert.isNull((Object)this.metaMap.get(meta.getName()), (String)"Meta[{}] exist!", (Object[])new Object[]{meta.getName()});
        this.metaMap.put(meta.getName(), meta);
        return this;
    }

    public Metas addHeaders(Headers headers) {
        Assert.isNull((Object)this.headersMap.get(headers.getName()), (String)"headers[{}] \u540d\u5b57\u91cd\u590d", (Object[])new Object[]{headers.getName()});
        this.headersMap.putIfAbsent(headers.getName(), headers);
        if (!headers.isFlushed()) {
            headers.flush();
        }
        return this;
    }

    public IMeta getMeta(String label) {
        return this.metaMap.get(label);
    }

    public List<IMeta> getMetas() {
        return MapUtil.convertValueToList(this.metaMap);
    }

    public Headers getHeadersByName(String name) {
        return this.headersMap.get(name);
    }

    public List<Headers> getHeaders() {
        return MapUtil.convertValueToList(this.headersMap);
    }
}

