/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header.row;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.row.HeaderRow;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public class HeaderRowContext {
    public static final String PROPERTY_KEY_SUFFIX = "[].";
    private final HeaderRow rootHeaderRow;
    private final List<HeaderRow> headerRows = new ArrayList<HeaderRow>();
    private final Map<String, HeaderRow> pathHeaderRowMap = new HashMap<String, HeaderRow>(16);
    private final Map<IDataHeader, HeaderRow> datHeaderHeaderRowMap = new HashMap<IDataHeader, HeaderRow>(16);

    public HeaderRowContext() {
        this.rootHeaderRow = new HeaderRow();
        this.rootHeaderRow.path = "";
        this.rootHeaderRow.paths = CollectionUtil.list((Object[])new String[]{""});
        this.headerRows.add(this.rootHeaderRow);
        this.pathHeaderRowMap.put("", this.rootHeaderRow);
    }

    public HeaderRow addHeader(IDataHeader header) {
        String key = header.getKey();
        if (key.endsWith("[]")) {
            key = key.concat(".");
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("");
        int dotIndex = -1;
        String lastPath = "";
        while ((dotIndex = key.indexOf(PROPERTY_KEY_SUFFIX, dotIndex + PROPERTY_KEY_SUFFIX.length())) != -1) {
            lastPath = key.substring(0, dotIndex + PROPERTY_KEY_SUFFIX.length() - 1);
            paths.add(lastPath);
        }
        HeaderRow headerRow = this.pathHeaderRowMap.get(lastPath);
        if (headerRow == null) {
            headerRow = new HeaderRow();
            headerRow.path = lastPath;
            headerRow.paths = paths;
            this.findRightPositionForHeaderRow(headerRow);
            this.headerRows.add(headerRow);
            this.pathHeaderRowMap.put(lastPath, headerRow);
            this.datHeaderHeaderRowMap.put(header, headerRow);
        }
        headerRow.addHeader(header);
        return headerRow;
    }

    private void findRightPositionForHeaderRow(HeaderRow headerRow) {
        HeaderRow row = this.rootHeaderRow;
        int headerRowPathLength = headerRow.paths.size();
        while (row != null) {
            int rowPathLength = row.paths.size();
            if (rowPathLength < headerRowPathLength) {
                Assert.isTrue((boolean)CollectionUtil.equals(row.paths, headerRow.paths, (int)rowPathLength));
                if (row.child == null) {
                    row.child = headerRow;
                    headerRow.parent = row;
                    break;
                }
                row = row.child;
                continue;
            }
            if (rowPathLength > headerRowPathLength) {
                Assert.isTrue((boolean)CollectionUtil.equals(row.paths, headerRow.paths, (int)headerRowPathLength));
                HeaderRow parent = row.parent;
                parent.child = headerRow;
                headerRow.parent = parent;
                headerRow.child = row;
                row.parent = headerRow;
                continue;
            }
            throw new IllegalArgumentException("check header's key ");
        }
    }

    public HeaderRow getRootHeaderRow() {
        return this.rootHeaderRow;
    }

    public List<HeaderRow> getHeaderRows() {
        return this.headerRows;
    }

    public HeaderRow getHeaderRowByPath(String path) {
        return this.pathHeaderRowMap.get(path);
    }

    public HeaderRow getHeaderRowByHeader(IDataHeader header) {
        return this.datHeaderHeaderRowMap.get(header);
    }
}

