/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.ArrayDataHeader;
import jexx.poi.header.DefaultDataHeader;
import jexx.poi.header.GroupHeader;
import jexx.poi.header.HeadersFactory;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.IGroupHeader;
import jexx.poi.header.IHeader;
import jexx.poi.header.SequenceDataHeader;
import jexx.poi.header.TreeDataHeader;
import jexx.poi.header.factory.HeadersFactoryImpl;
import jexx.poi.header.row.HeaderRowContext;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.TreeMeta;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.writer.RowTrigger;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Headers {
    private static final Logger LOG = LoggerFactory.getLogger(Headers.class);
    public static final String INDEX_TAG = "[]";
    public static final String DEFAULT_HEADERS = "default";
    private final String name;
    private final int startHeaderNum;
    private final List<IHeader> headers = new ArrayList<IHeader>();
    private final List<IDataHeader> dataHeaders = new ArrayList<IDataHeader>();
    private final Map<String, IDataHeader> dataHeaderMap = new HashMap<String, IDataHeader>(16);
    private final Map<Integer, IDataHeader> dataHeaderIndexMap = new HashMap<Integer, IDataHeader>(16);
    private final List<ICustomHeader> customHeaders = new ArrayList<ICustomHeader>();
    protected Map<IHeader, List<RowTrigger>> rowTriggerMap = new LinkedHashMap<IHeader, List<RowTrigger>>(16);
    protected HeaderRowContext headerRowContext = new HeaderRowContext();
    private IWrapCellStyle defaultHeaderCellStyle = CellStyleSets.HEADER_CELL_STYLE;
    private IWrapCellStyle defaultDataCellStyle = CellStyleSets.DATA_CELL_STYLE;
    private int currentHeaderNum = 1;
    private int maxHeaderNum = 1;
    protected boolean flushed;
    private boolean index;

    public Headers() {
        this(DEFAULT_HEADERS);
    }

    public Headers(String name) {
        this(1, name);
    }

    public Headers(int startHeaderNum) {
        this(startHeaderNum, DEFAULT_HEADERS);
    }

    public Headers(int startHeaderNum, String name) {
        Assert.isTrue((startHeaderNum > 0 ? 1 : 0) != 0, (String)"startHeaderNum={}", (Object[])new Object[]{startHeaderNum});
        this.startHeaderNum = startHeaderNum;
        this.currentHeaderNum = startHeaderNum;
        this.maxHeaderNum = startHeaderNum;
        this.name = name;
    }

    public static HeadersFactory newBuild() {
        return new HeadersFactoryImpl();
    }

    public String getName() {
        return this.name;
    }

    public Headers skipColumns(int columnCount) {
        Assert.isTrue((columnCount > 0 ? 1 : 0) != 0);
        this.currentHeaderNum += columnCount;
        return this;
    }

    public Headers skipToOneColumn(int columnNum) {
        Assert.isTrue((columnNum > this.currentHeaderNum ? 1 : 0) != 0);
        this.currentHeaderNum = columnNum;
        return this;
    }

    public Headers skipToOneColumn(String columnNo) {
        int columnNum = CellOperateUtil.toColumnNum(columnNo);
        return this.skipToOneColumn(columnNum);
    }

    public void addHeaders(Map<String, String> headerAlias) {
        for (Map.Entry<String, String> entry : headerAlias.entrySet()) {
            this.addHeader(new DefaultDataHeader(entry.getKey(), entry.getValue()));
        }
    }

    private void doAddHeader(IHeader header) {
        if (CollectionUtil.isNotEmpty(this.headers)) {
            ++this.currentHeaderNum;
        }
        Assert.isTrue((header.getColumnCount() > 0 ? 1 : 0) != 0);
        if (header.getStartColumnNum() <= 0) {
            this.handleColumn(header, this.currentHeaderNum);
        }
        this.currentHeaderNum = header.getEndColumnNum();
        Assert.isTrue((header.getStartColumnNum() > 0 && header.getEndColumnNum() >= header.getStartColumnNum() ? 1 : 0) != 0);
        this.headers.add(header);
        if (this.maxHeaderNum < this.currentHeaderNum) {
            this.maxHeaderNum = this.currentHeaderNum;
        }
        this.flushed = false;
    }

    public IDataHeader addHeader(IDataHeader header) {
        this.doAddHeader(header);
        this.doAddDataHeader(header);
        return header;
    }

    private void doAddDataHeader(IDataHeader header) {
        if (!this.index) {
            this.index = header.getKey().contains("[") || header.getKey().contains(".");
        }
        this.dataHeaders.add(header);
        this.dataHeaderMap.put(header.getKey(), header);
        this.dataHeaderIndexMap.put(header.getStartColumnNum(), header);
        this.headerRowContext.addHeader(header);
    }

    public ICustomHeader addHeader(ICustomHeader header) {
        this.doAddHeader(header);
        this.doAddCustomHeader(header);
        return header;
    }

    private void doAddCustomHeader(ICustomHeader header) {
        this.customHeaders.add(header);
    }

    public IGroupHeader addHeader(IGroupHeader header) {
        this.doAddHeader(header);
        this.doAddGroupHeader(header);
        return header;
    }

    private void doAddGroupHeader(IGroupHeader header) {
        List<IHeader> children = header.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (IHeader h : children) {
                if (h instanceof IDataHeader) {
                    this.doAddDataHeader((IDataHeader)h);
                    continue;
                }
                if (h instanceof IGroupHeader) {
                    this.doAddGroupHeader((IGroupHeader)h);
                    continue;
                }
                if (h instanceof ICustomHeader) {
                    this.doAddCustomHeader((ICustomHeader)h);
                    continue;
                }
                throw new UnsupportedOperationException(StringUtil.format((String)"no support header {}", (Object[])new Object[]{h}));
            }
        }
    }

    private void handleColumn(IHeader header, int startColumnNum) {
        header.setStartColumnNum(startColumnNum);
        header.setEndColumnNum(startColumnNum + header.getColumnCount() - 1);
        if (header instanceof IGroupHeader) {
            List<IHeader> children = ((IGroupHeader)header).getChildren();
            int start = startColumnNum;
            for (IHeader child : children) {
                this.handleColumn(child, start);
                start = child.getEndColumnNum() + 1;
            }
        }
    }

    public IDataHeader addHeader(String label, String value, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        DefaultDataHeader header = new DefaultDataHeader(label, value);
        header.setHeaderCellStyle(headerCellStyle);
        header.setDataCellStyle(dataCellStyle);
        return this.addHeader(header);
    }

    public IDataHeader addHeader(String label, String value) {
        return this.addHeader(label, value, this.defaultHeaderCellStyle, this.defaultDataCellStyle);
    }

    public IDataHeader addArrayHeader(String label, String value, ArrayMeta meta, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        ArrayDataHeader header = new ArrayDataHeader(label, value, meta);
        header.setHeaderCellStyle(headerCellStyle);
        header.setDataCellStyle(dataCellStyle);
        return this.addHeader(header);
    }

    public IDataHeader addArrayHeader(String label, String value, ArrayMeta meta) {
        return this.addArrayHeader(label, value, meta, this.defaultHeaderCellStyle, this.defaultDataCellStyle);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta, IDataHeader referHeader, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        TreeDataHeader header = new TreeDataHeader(label, value, meta, referHeader);
        header.setHeaderCellStyle(headerCellStyle);
        header.setDataCellStyle(dataCellStyle);
        return this.addHeader(header);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta, String referHeaderName, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        IDataHeader referHeader = this.dataHeaderMap.get(referHeaderName);
        Assert.notNull((Object)referHeader, (String)"refer header[{}] is null", (Object[])new Object[]{referHeaderName});
        return this.addTreeHeader(label, value, meta, referHeader, headerCellStyle, dataCellStyle);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        return this.addTreeHeader(label, value, meta, (IDataHeader)null, headerCellStyle, dataCellStyle);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta, IDataHeader referHeader) {
        return this.addTreeHeader(label, value, meta, referHeader, this.defaultHeaderCellStyle, this.defaultDataCellStyle);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta, String referHeaderName) {
        IDataHeader referHeader = this.dataHeaderMap.get(referHeaderName);
        Assert.notNull((Object)referHeader, (String)"refer header[{}] is null", (Object[])new Object[]{referHeaderName});
        return this.addTreeHeader(label, value, meta, referHeader, this.defaultHeaderCellStyle, this.defaultDataCellStyle);
    }

    public IDataHeader addTreeHeader(String label, String value, TreeMeta meta) {
        return this.addTreeHeader(label, value, meta, (IDataHeader)null, this.defaultHeaderCellStyle, this.defaultDataCellStyle);
    }

    public ICustomHeader addSequenceHeader(String value) {
        return this.addSequenceHeader(value, null);
    }

    public ICustomHeader addSequenceHeader(String value, IDataHeader sameLevelHeader) {
        return this.addHeader(new SequenceDataHeader(value, sameLevelHeader));
    }

    public void flush() {
        for (ICustomHeader customHeader : this.customHeaders) {
            if (!StringUtil.isNotEmpty((CharSequence)customHeader.getSameLevelHeaderName()) || customHeader.getSameLevelHeader() != null) continue;
            IDataHeader sameLevelHeader = this.dataHeaderMap.get(customHeader.getSameLevelHeaderName());
            Assert.notNull((Object)sameLevelHeader, (String)"can't find header[{}]", (Object[])new Object[]{customHeader.getSameLevelHeaderName()});
            customHeader.setSameLevelHeader(sameLevelHeader);
        }
        this.flushed = true;
    }

    public List<IHeader> getHeaders() {
        return this.headers;
    }

    public List<ICustomHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    public List<IDataHeader> getDataHeaders() {
        return this.dataHeaders;
    }

    public int getStartHeaderNum() {
        return this.startHeaderNum;
    }

    public int getMaxHeaderNum() {
        return this.maxHeaderNum;
    }

    public IDataHeader getDataHeaderByColumnNum(int columnNum) {
        return this.dataHeaderIndexMap.get(columnNum);
    }

    public IDataHeader getDataHeaderByLabel(String label) {
        return this.dataHeaderMap.get(label);
    }

    public boolean matchColumnNum(int columnNum, String ... labels) {
        for (String label : labels) {
            IDataHeader header = this.getDataHeaderByLabel(label);
            if (header == null || header.getStartColumnNum() != columnNum) continue;
            return true;
        }
        return false;
    }

    public boolean isIndex() {
        return this.index;
    }

    public List<IMergedCell> createHeaderCells(int startRowNum) {
        ArrayList<IMergedCell> cells = new ArrayList<IMergedCell>();
        ArrayList<HeaderMergeCell> dataCells = new ArrayList<HeaderMergeCell>();
        int maxEndRowNum = this.doCreateHeaderCells(this.headers, startRowNum, cells, dataCells);
        for (HeaderMergeCell cell : dataCells) {
            if (cell.getLastRowNum() >= maxEndRowNum) continue;
            cell.setLastRowNum(maxEndRowNum);
        }
        return cells;
    }

    private int doCreateHeaderCells(List<IHeader> headers, int startRowNum, List<IMergedCell> cells, List<HeaderMergeCell> dataCells) {
        int maxEndRowNum = startRowNum;
        if (CollectionUtil.isNotEmpty(headers)) {
            for (IHeader header : headers) {
                HeaderMergeCell cell = new HeaderMergeCell(startRowNum, header.getStartColumnNum(), startRowNum, header.getEndColumnNum(), (Object)header.getValue(), header.getHeaderCellStyle());
                cells.add(cell);
                if (header instanceof GroupHeader) {
                    GroupHeader groupHeader = (GroupHeader)header;
                    int lastRowNum = this.doCreateHeaderCells(groupHeader.getChildren(), startRowNum + 1, cells, dataCells);
                    maxEndRowNum = Math.max(maxEndRowNum, lastRowNum);
                    continue;
                }
                if (header instanceof IDataHeader) {
                    dataCells.add(cell);
                    continue;
                }
                if (!(header instanceof ICustomHeader)) continue;
                dataCells.add(cell);
            }
        }
        return maxEndRowNum;
    }

    public void setDefaultHeaderCellStyle(IWrapCellStyle defaultHeaderCellStyle) {
        this.defaultHeaderCellStyle = defaultHeaderCellStyle;
    }

    public void setDefaultDataCellStyle(IWrapCellStyle defaultDataCellStyle) {
        this.defaultDataCellStyle = defaultDataCellStyle;
    }

    public void addRowTrigger(IDataHeader header, RowTrigger trigger) {
        List rowTriggers = this.rowTriggerMap.computeIfAbsent(header, s -> new ArrayList());
        rowTriggers.add(trigger);
    }

    public void addRowTrigger(String headerName, RowTrigger trigger) {
        IDataHeader header = this.dataHeaderMap.get(headerName);
        Assert.notNull((Object)header, (String)"header[{}] not exist", (Object[])new Object[]{headerName});
        this.addRowTrigger(header, trigger);
    }

    public List<RowTrigger> getRowTriggers(IHeader header) {
        return this.rowTriggerMap.get(header);
    }

    public List<RowTrigger> getRowTriggers(int headerColumnNum) {
        IDataHeader header = this.dataHeaderIndexMap.get(headerColumnNum);
        if (header != null) {
            return this.getRowTriggers(header);
        }
        return null;
    }

    public boolean hasRowTrigger() {
        return CollectionUtil.isNotEmpty(this.rowTriggerMap);
    }

    public HeaderRowContext getHeaderRowContext() {
        return this.headerRowContext;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    private static class HeaderMergeCell
    extends MergedCell {
        public HeaderMergeCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
            super(firstRowNum, firstColumnNum, lastRowNum, lastColumnNum, value, cellStyle);
        }

        public void setLastRowNum(int lastRowNum) {
            this.lastRowNum = lastRowNum;
        }
    }
}

