/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.constant;

import java.util.HashMap;
import java.util.Map;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;

public enum EmbeddedDataStyleName {
    HEADER("_header"),
    DATA("_data"),
    NONE("_none"),
    DATE_YEAR("_year"),
    DATE_MONTH("_month"),
    DATE("_date"),
    DATE_TIME("_datetime"),
    FORMULA("_formula"),
    DECIMAL_TWO_PRECISION("_twoDecimal");

    private String name;

    private EmbeddedDataStyleName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static void wrapEmbeddedDataStyle(Map<String, IWrapCellStyle> cellStyleMap) {
        cellStyleMap.put(EmbeddedDataStyleName.HEADER.name, CellStyleSets.HEADER_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DATA.name, CellStyleSets.DATA_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.NONE.name, CellStyleSets.NONE_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DATE_YEAR.name, CellStyleSets.YEAR_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DATE_MONTH.name, CellStyleSets.MONTH_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DATE.name, CellStyleSets.DATE_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DATE_TIME.name, CellStyleSets.DATE_TIME_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.FORMULA.name, CellStyleSets.FORMULA_CELL_STYLE);
        cellStyleMap.put(EmbeddedDataStyleName.DECIMAL_TWO_PRECISION.name, CellStyleSets.DECIMAL_TWO_CELL_STYLE);
    }

    public static Map<String, IWrapCellStyle> getEmbeddedDataStyle() {
        HashMap<String, IWrapCellStyle> cellStyleMap = new HashMap<String, IWrapCellStyle>(16);
        EmbeddedDataStyleName.wrapEmbeddedDataStyle(cellStyleMap);
        return cellStyleMap;
    }
}

