/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.cell;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jexx.poi.style.IWrapCellStyle;

public interface ICell {
    public String getId();

    public int getFirstRowNum();

    public int getFirstColumnNum();

    public String getFirstColumnNo();

    public boolean isMultiValue();

    public Object getValue();

    default public Object[] getValues() {
        Object[] values;
        if (!this.isMultiValue()) {
            Object[] values2 = new Object[]{this.getValue()};
            return values2;
        }
        Object value = this.getValue();
        if (value == null) {
            return new Object[0];
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            values = new Object[length];
            for (int i = 0; i < length; ++i) {
                values[i] = Array.get(value, i);
            }
        } else if (value instanceof List) {
            int length = ((List)value).size();
            values = new Object[length];
            for (int i = 0; i < length; ++i) {
                values[i] = ((List)value).get(i);
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            int length = set.size();
            values = new Object[length];
            Iterator iterator = set.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                values[i++] = iterator.next();
            }
        } else {
            throw new UnsupportedOperationException("Multi value cannot support class " + value.getClass());
        }
        return values;
    }

    public void setValue(Object var1);

    public Object getLabel();

    public void setLabel(Object var1);

    public IWrapCellStyle getCellStyle();

    public void setCellStyle(IWrapCellStyle var1);
}

