/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.cell;

import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.IRowCell;
import jexx.poi.row.Row;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.random.RandomUtil;
import jexx.util.Assert;

public abstract class AbstractCell
implements IMergedCell,
IRowCell {
    protected String id;
    protected int firstRowNum;
    protected int firstColumnNum;
    protected int lastRowNum;
    protected int lastColumnNum;
    protected boolean multiValue;
    protected Object value;
    protected Object label;
    protected boolean labelSet;
    protected IWrapCellStyle cellStyle;
    protected Row row;

    public AbstractCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        Assert.isTrue((firstRowNum <= lastRowNum && firstColumnNum <= lastColumnNum ? 1 : 0) != 0, (String)"firstRowNum={}, firstColumnNum={},lastRowNum={},lastColumnNum={}", (Object[])new Object[]{firstRowNum, firstColumnNum, lastRowNum, lastColumnNum});
        this.id = RandomUtil.simpleUUID();
        this.firstRowNum = firstRowNum;
        this.firstColumnNum = firstColumnNum;
        this.lastRowNum = lastRowNum;
        this.lastColumnNum = lastColumnNum;
        this.value = value;
        this.label = value;
        this.cellStyle = cellStyle;
    }

    public AbstractCell(int firstRowNum, int firstColumnNum, Object value, IWrapCellStyle cellStyle) {
        this(firstRowNum, firstColumnNum, firstRowNum, firstColumnNum, value, cellStyle);
    }

    public AbstractCell(Row row, int firstColumnNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        this(row.getStartRowNum(), firstColumnNum, row.getEndRowNum(), lastColumnNum, value, cellStyle);
        this.row = row;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getFirstRowNum() {
        return this.row != null ? this.row.getStartRowNum() : this.firstRowNum;
    }

    @Override
    public int getLastRowNum() {
        return this.row != null ? this.row.getEndRowNum() : this.lastRowNum;
    }

    @Override
    public int getFirstColumnNum() {
        return this.firstColumnNum;
    }

    @Override
    public int getLastColumnNum() {
        return this.lastColumnNum;
    }

    @Override
    public String getFirstColumnNo() {
        return CellOperateUtil.toColumnLabel(this.getFirstColumnNum());
    }

    @Override
    public String getLastColumnNo() {
        return CellOperateUtil.toColumnLabel(this.getLastColumnNum());
    }

    @Override
    public boolean isMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getLabel() {
        if (!this.labelSet) {
            this.setValue(this.value);
        }
        return this.label;
    }

    @Override
    public void setLabel(Object label) {
        this.label = label;
        this.labelSet = true;
    }

    @Override
    public IWrapCellStyle getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public void setCellStyle(IWrapCellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    @Override
    public Row getRow() {
        return this.row;
    }
}

