/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jexx.exception.IORuntimeException;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.poi.SheetWriter;
import jexx.poi.constant.ExcelWriteMode;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.WorkbookUtil;
import jexx.poi.writer.AbstractExcelWriter;
import jexx.poi.writer.impl.SheetWriterImpl;
import jexx.util.Assert;
import jexx.util.StringUtil;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter
extends AbstractExcelWriter {
    protected List<SheetWriter> sheetWriters = new ArrayList<SheetWriter>();

    public ExcelWriter() {
        this(true);
    }

    public ExcelWriter(boolean isXlsx) {
        this(WorkbookUtil.createBook(isXlsx));
    }

    public ExcelWriter(Workbook workbook) {
        super(workbook, true, 0);
    }

    public ExcelWriter(File file) {
        this(WorkbookUtil.createBook(file));
    }

    public ExcelWriter(InputStream inputStream, boolean hiddenMetaSheet) {
        super(WorkbookUtil.createBook(inputStream), hiddenMetaSheet, 0);
    }

    public ExcelWriter(InputStream inputStream) {
        this(inputStream, true);
    }

    public SheetWriter sheet() {
        return this.sheet("Sheet1");
    }

    public SheetWriter sheet(String sheetName) {
        Assert.isTrue((!"__METADATA__".equalsIgnoreCase(sheetName) ? 1 : 0) != 0, (String)"Sheet name is not equal to {}", (Object[])new Object[]{sheetName});
        if (StringUtil.isEmpty((CharSequence)sheetName)) {
            sheetName = "Sheet1";
        }
        Sheet sheet = this.getOrCreateSheet(sheetName);
        SheetWriterImpl sheetWriter = new SheetWriterImpl(sheet);
        this.sheetWriters.add(sheetWriter);
        return sheetWriter;
    }

    public ExcelWriter evaluateFormulaCell() {
        this.flushSheetWriter();
        this.workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        return this;
    }

    public ExcelWriter flush(File destFile) {
        return this.flush(destFile, ExcelWriteMode.DEFAULT_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelWriter flush(File destFile, ExcelWriteMode writeMode) {
        BufferedOutputStream out = null;
        try {
            out = FileUtil.newBufferedOutputStream((File)destFile);
            this.flush(out, writeMode);
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
        return this;
    }

    public ExcelWriter flush(OutputStream out) {
        return this.flush(out, ExcelWriteMode.DEFAULT_MODE);
    }

    public ExcelWriter flush(OutputStream out, ExcelWriteMode writeMode) {
        try {
            this.flushSheetWriter();
            if (ExcelWriteMode.VIEW_MODE == writeMode) {
                FormulaEvaluator evaluator = null;
                for (Sheet sheet : this.workbook) {
                    if ("__METADATA__".equals(sheet.getSheetName())) continue;
                    for (Row row : sheet) {
                        block10: for (Cell cell : row) {
                            if (CellType.FORMULA != cell.getCellTypeEnum()) continue;
                            if (evaluator == null) {
                                evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
                            }
                            CellValue cellValue = evaluator.evaluate(cell);
                            switch (cellValue.getCellTypeEnum()) {
                                case NUMERIC: {
                                    CellOperateUtil.setCellValue(cell, cellValue.getNumberValue());
                                    continue block10;
                                }
                                case STRING: {
                                    CellOperateUtil.setCellValue(cell, cellValue.getStringValue());
                                    continue block10;
                                }
                                case BOOLEAN: {
                                    CellOperateUtil.setCellValue(cell, cellValue.getBooleanValue());
                                    continue block10;
                                }
                                case ERROR: {
                                    CellOperateUtil.setCellValue(cell, ErrorEval.getText((int)cellValue.getErrorValue()));
                                    continue block10;
                                }
                            }
                            CellOperateUtil.setCellValue(cell, "<error unexpected cell type " + cellValue.getCellTypeEnum() + ">");
                        }
                    }
                }
            }
            this.workbook.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    private void flushSheetWriter() {
        for (SheetWriter sheetWriter : this.sheetWriters) {
            sheetWriter.flush();
        }
    }
}

