package jexx.poi.meta.node;

import jexx.poi.meta.AbstractMeta;
import jexx.poi.util.NameUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

import java.util.List;

/**
 * tree node
 *
 * @author jeff
 */
public class TreeNode implements INode {

    public static final String ROOT_NODE_NAME = "RooT";

    private Object value;
    private Object label;
    private TreeNode parent;
    private List<TreeNode> children;
    private boolean isRoot;
    private boolean isLeaf;

    public TreeNode(Object value) {
        this(value, value);
    }

    public TreeNode(Object value, Object label) {
        this(value, label, null, null);
    }

    public TreeNode(Object value, Object label, TreeNode parent, List<TreeNode> children) {
        Assert.notNull(value);
        Assert.notNull(label);
        this.value = value;
        this.label = label;
        this.parent = parent;
        this.children = children;
    }

    /**
     * 创建根节点
     */
    public static TreeNode createRootTreeNode(){
        return createRootTreeNode(ROOT_NODE_NAME);
    }

    public static TreeNode createRootTreeNode(String name){
        TreeNode root = new TreeNode(name);
        root.isRoot = true;
        return root;
    }

    /**
     * 由树节点中各个值组成的全路径, 如 部门_1_11_112
     */
    public String getFullValue(){
        StringBuilder valueBuilder = new StringBuilder();
        if(parent != null){
            valueBuilder.append(parent.getFullValue()).append(AbstractMeta.SEPARATOR);
        }
        valueBuilder.append(this.value);
        return valueBuilder.toString();
    }

    /**
     * 树节点代表的全路径名称, 如 部门_部门1_职位11_姓名112
     */
    public String getFullLabel(){
        StringBuilder labelBuilder = new StringBuilder();
        if(parent != null){
            labelBuilder.append(parent.getFullLabel()).append(AbstractMeta.SEPARATOR);
        }
        labelBuilder.append(getLabel());
        return labelBuilder.toString();
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public Object getLabel() {
        if(this.label != null && CollectionUtil.isNotEmpty(children)){
            //级联需要对上一级数据判断是否符合名称管理器的规则. 这样保证了 数据 转为名称管理器名称时不会出错
            return NameUtil.replaceIllegalCharForName(label.toString());
        }
        return this.label;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public TreeNode getParent() {
        return parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public boolean isRoot() {
        return isRoot;
    }

    public void setRoot(boolean root) {
        isRoot = root;
    }

    public boolean isLeaf() {
        return isLeaf;
    }

    public void setLeaf(boolean leaf) {
        isLeaf = leaf;
    }

    @Override
    public int hashCode() {
        int code = getFullValue().hashCode();
        code = 31 * code;
        return code;
    }

    @Override
    public boolean equals(Object o) {
        if(o instanceof TreeNode){
            TreeNode another = (TreeNode)o;
            return this.getFullLabel().equals(another.getFullValue());
        }
        return false;
    }
}
