package jexx.poi.header;

import jexx.poi.meta.AbstractMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * tree header
 *
 * @author jeff
 */
public class TreeDataHeader extends AbstractDataHeader {

    private TreeMeta meta;
    private IDataHeader referHeader;

    public TreeDataHeader(String key, String value, int columnCount, TreeMeta meta, IDataHeader referHeader) {
        super(key, value, columnCount);
        this.meta = meta;
        this.referHeader = referHeader;
    }

    /**
     * 构造级联头部信息
     * @param key 变量名称
     * @param value 变量对应解释名称
     * @param meta 级联所需元数据
     * @param referHeader 引用另一个头部信息来构建名称,请确保该头部信息已存在
     */
    public TreeDataHeader(String key, String value, TreeMeta meta, IDataHeader referHeader) {
        this(key, value, 1, meta, referHeader);
    }

    @Override
    public DVConstraintType getDVConstraintType() {
        return DVConstraintType.TREE;
    }

    @Override
    public IDataHeader getReferHeader(){
        return referHeader;
    }

    @Override
    public TreeMeta getMeta() {
        return meta;
    }

    @Override
    public INode getNodeByLabel(Map<String, Object> labelMap){
        String fullLabel = getLabelOrValue(labelMap);
        return meta.getNodeByFullLabel(fullLabel);
    }

    private String getLabelOrValue(Map<?, ?> data){
        Object lv = data.get(key);

        List<Object> lvs = new ArrayList<>();
        lvs.add(lv);

        IDataHeader next = referHeader;
        while(next != null){
            lvs.add(data.get(next.getKey()));
            next = next.getReferHeader();
        }

        int length = lvs.size();
        StringBuilder sb = new StringBuilder(meta.getName());
        for(int i = length - 1; i >= 0; i--){
            sb.append(AbstractMeta.SEPARATOR).append(lvs.get(i));
        }
        return sb.toString();
    }

}
