package jexx.poi.header;

import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.Node;
import jexx.poi.style.IWrapCellStyle;

import java.util.Map;

/**
 * default header
 *
 * @author jeff
 */
public class DefaultDataHeader extends AbstractDataHeader {

    public DefaultDataHeader(String key, String value) {
        this(key, value, 1);
    }

    public DefaultDataHeader(String key, String value, int columnCount) {
        super(key, value, columnCount);
    }

    public DefaultDataHeader(String key, String value, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        this(key, value, 1, headerCellStyle, dataCellStyle);
    }

    public DefaultDataHeader(String key, String value, int columnCount, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        super(key, value, columnCount, headerCellStyle, dataCellStyle);
    }

    @Override
    public DVConstraintType getDVConstraintType() {
        return DVConstraintType.DEFAULT;
    }

    @Override
    public IDataHeader getReferHeader() {
        return null;
    }

    @Override
    public IMeta getMeta() {
        return null;
    }

    @Override
    public INode getNodeByLabel(Map<String, Object> labelMap) {
        return new Node(labelMap.get(key));
    }
}
