package jexx.poi.header;

import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.NullNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class ArrayDataHeader extends AbstractDataHeader {

    private static final Logger LOG = LoggerFactory.getLogger(ArrayDataHeader.class);

    private ArrayMeta meta;

    public ArrayDataHeader(String key, String value, int columnCount, ArrayMeta meta) {
        super(key, value, columnCount);
        this.meta = meta;
    }

    public ArrayDataHeader(String key, String value, ArrayMeta meta) {
        this(key, value, 1, meta);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public DVConstraintType getDVConstraintType() {
        return DVConstraintType.ARRAY;
    }

    @Override
    public ArrayMeta getMeta() {
        return meta;
    }

    @Override
    public IDataHeader getReferHeader() {
        return null;
    }

    @Override
    public INode getNodeByLabel(Map<String, Object> labelMap){
        Object label = labelMap.get(key);
        if(label == null){
            return NullNode.instance();
        }
        return meta.getNodeByFullLabel(label.toString());
    }

}
