package jexx.poi.header;

import jexx.poi.header.label.LabelFunction;
import jexx.poi.header.label.LabelUnwrapFunction;
import jexx.poi.header.label.LabelWrapFunction;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;

import java.util.Objects;

/**
 * abstract data header
 *
 * @author jeff
 */
public abstract class AbstractDataHeader<T extends AbstractDataHeader> extends AbstractHeader implements IDataHeader {

    /**
     * valid data if include meta
     */
    protected boolean valid = true;

    /**
     * label加工方法
     */
    protected LabelWrapFunction labelWrapFunction;
    /**
     * label解加工方法
     */
    protected LabelUnwrapFunction labelUnwrapFunction;

    /**
     * 数据样式
     */
    private IWrapCellStyle dataCellStyle;

    public AbstractDataHeader(String key, String value) {
        this(key, value, 1);
    }

    public AbstractDataHeader(String key, String value, int columnCount) {
        this(key, value, columnCount, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    public AbstractDataHeader(String key, String value, int columnCount, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        Objects.requireNonNull(key);
        this.key = key;
        this.value = value;
        this.columnCount = columnCount;
        this.headerCellStyle = headerCellStyle;
        this.dataCellStyle = dataCellStyle;
    }

    @SuppressWarnings("unchecked")
    private T _this(){
        return (T)this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public T setValid(boolean valid) {
        this.valid = valid;
        return _this();
    }

    /**
     * 提供对包装label和实际label显示
     */
    public T label(LabelFunction labelFunction){
        wrapLabel(labelFunction);
        unwrapLabel(labelFunction);
        return _this();
    }

    /**
     * 包装label
     */
    public T wrapLabel(LabelWrapFunction labelWrapFunction){
        this.labelWrapFunction = labelWrapFunction;
        return _this();
    }

    /**
     * 转换实际label
     */
    public T unwrapLabel(LabelUnwrapFunction labelUnwrapFunction){
        this.labelUnwrapFunction = labelUnwrapFunction;
        return _this();
    }

    /**
     * 设置数据样式
     * @param dataCellStyle 数据样式
     */
    public T setDataCellStyle(IWrapCellStyle dataCellStyle) {
        this.dataCellStyle = dataCellStyle;
        return _this();
    }

    @Override
    public LabelWrapFunction getWrapLabelFunction() {
        return labelWrapFunction;
    }

    @Override
    public LabelUnwrapFunction getUnwrapLabelFunction() {
        return labelUnwrapFunction;
    }

    @Override
    public IWrapCellStyle getDataCellStyle() {
        return dataCellStyle;
    }
}
