package jexx.poi.cell;

import jexx.poi.style.IWrapCellStyle;

/**
 * 基类单元格
 *
 * @author jeff
 * @since 2019/5/7
 */
public interface ICell {

    String getId();

    /**
     * the first cell's row num, base 1
     *
     * @return row num
     */
    int getFirstRowNum();

    /**
     * the first cell's column num, base 1
     *
     * @return column num
     */
    int getFirstColumnNum();

    /**
     * the first cell's column no, base A;
     *
     * @return column no
     */
    String getFirstColumnNo();

    /**
     * 单元格实际值
     */
    Object getValue();

    /**
     * 设置cell值
     */
    void setValue(Object value);

    /**
     * 单元格显示值
     */
    Object getLabel();

    /**
     * 设置cell显示
     */
    void setLabel(Object label);

    /**
     * cell style
     *
     * @return {@link IWrapCellStyle}
     */
    IWrapCellStyle getCellStyle();

    /**
     * 设置单元格样式
     * @param cellStyle 样式
     */
    void setCellStyle(IWrapCellStyle cellStyle);


}
