/*
 * Decompiled with CFR 0.152.
 */
package jexx.mail;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Authenticator;
import jexx.mail.MailSession;
import jexx.mail.SimpleAuthenticator;
import jexx.mail.SmtpServer;
import jexx.mail.SmtpSslServer;

public abstract class MailServer<MailSessionImpl extends MailSession> {
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_MIME_SPLITLONGPARAMETERS = "mail.mime.splitlongparameters";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_WRITETIMEOUT = "mail.smtp.writetimeout";
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    public static final String MAIL_DEBUG = "mail.debug";
    protected final String host;
    protected final int port;
    protected final Authenticator authenticator;
    protected final int timeout;
    protected final Properties customProperties;
    protected final boolean debugMode;

    protected MailServer(Builder builder, int defaultPort) {
        Objects.requireNonNull(builder.host, "Host cannot be null");
        this.host = builder.host;
        this.port = builder.port == -1 ? defaultPort : builder.port;
        this.authenticator = builder.authenticator;
        this.timeout = builder.timeout;
        this.debugMode = builder.debug;
        this.customProperties = builder.customProperties;
        this.initSystemProperties();
    }

    protected void initSystemProperties() {
        System.setProperty(MAIL_MIME_SPLITLONGPARAMETERS, "false");
    }

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.customProperties);
        if (this.debugMode) {
            props.put(MAIL_DEBUG, "true");
        }
        return props;
    }

    public abstract MailSessionImpl createSession();

    public static Builder create() {
        return new Builder();
    }

    public String toString() {
        return "MailServer{host='" + this.host + '\'' + ", port=" + this.port + ", timeout=" + this.timeout + ", customProperties=" + this.customProperties + ", debugMode=" + this.debugMode + '}';
    }

    public static class Builder {
        private String host = null;
        private int port = -1;
        private boolean ssl = false;
        private boolean starttls = false;
        private Authenticator authenticator;
        private int timeout = 300000;
        private Properties customProperties = new Properties();
        private boolean debug;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder starttls(boolean starttls) {
            this.starttls = starttls;
            return this;
        }

        public Builder debugMode(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder auth(String username, String password) {
            Objects.requireNonNull(username, "Username cannot be null");
            Objects.requireNonNull(password, "Password cannot be null");
            return this.auth(new SimpleAuthenticator(username, password));
        }

        public Builder auth(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder property(String name, String value) {
            this.customProperties.put(name, value);
            return this;
        }

        public SmtpServer buildSmtpMailServer() {
            if (this.ssl || this.starttls) {
                SmtpSslServer smtpSslServer = new SmtpSslServer(this);
                smtpSslServer.startTlsRequired(this.starttls);
                smtpSslServer.startSsl(this.ssl);
                return smtpSslServer;
            }
            return new SmtpServer(this);
        }
    }
}

