/*
 * Decompiled with CFR 0.152.
 */
package jexx.mail;

import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import jexx.mail.MailException;

public abstract class MailSession<T extends Service>
implements AutoCloseable {
    private final Session session;
    protected final T service;

    protected MailSession(Session session, T service) {
        this.session = session;
        this.service = service;
    }

    public void open() {
        try {
            this.service.connect();
        }
        catch (MessagingException e) {
            throw new MailException(e, "Open session error", new Object[0]);
        }
    }

    @Override
    public void close() {
        try {
            this.service.close();
        }
        catch (MessagingException e) {
            throw new MailException(e, "Failed to close session", new Object[0]);
        }
    }

    public boolean isConnected() {
        return this.service.isConnected();
    }

    public Session getSession() {
        return this.session;
    }

    public abstract T getService();
}

