package jexx.log.dialect.slf4j;

import jexx.log.Log;
import jexx.log.LogFactory;

public class Slf4jLogFactory extends LogFactory {

	
	public Slf4jLogFactory() {
		super("slf4j");
		checkLogExist(org.slf4j.LoggerFactory.class);
	}
	
	@Override
	public Log createLog(String name) {
		return new Slf4jLog(name);
	}
	
	@Override
	public Log createLog(Class<?> clazz) {
		return new Slf4jLog(clazz);
	}

}
