package jexx.log.dialect.jdk;

import jexx.log.Log;
import jexx.log.LogFactory;

public class JdkLogFactory extends LogFactory {

	
	public JdkLogFactory() {
		super("jdklog");
		checkLogExist(org.slf4j.LoggerFactory.class);
	}
	
	@Override
	public Log createLog(String name) {
		return new JdkLog(name);
	}
	
	@Override
	public Log createLog(Class<?> clazz) {
		return new JdkLog(clazz);
	}

}
