package jexx.log.dialect.console;

import jexx.log.AbstractLog;
import jexx.log.level.Level;
import jexx.util.Console;
import jexx.util.StringUtil;
import jexx.time.TimeUtil;

import java.time.LocalDateTime;

/**
 * console log
 *
 * @author jeff
 */
public class ConsoleLog extends AbstractLog {

	private static final long serialVersionUID = 1L;
	
	private static Level level = Level.DEBUG;
	
	private String name;
	
	public ConsoleLog(Class<?> clazz) {
		this.name = clazz.getName();
	}
	
	public ConsoleLog(String name) {
		this.name = name;
	}
	
	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public boolean isTraceEnabled() {
		return level.compareTo(Level.TRACE) <= 0;
	}

	@Override
	public void trace(String format, Object... arguments) {
		log(Level.TRACE, format, arguments);
	}

	@Override
	public void trace(Throwable t, String format, Object... arguments) {
		log(Level.TRACE, t, format, arguments);
	}

	@Override
	public boolean isDebugEnabled() {
		return level.compareTo(Level.DEBUG) <= 0;
	}

	@Override
	public void debug(String format, Object... arguments) {
		log(Level.DEBUG, format, arguments);
	}

	@Override
	public void debug(Throwable t, String format, Object... arguments) {
		log(Level.DEBUG, t, format, arguments);
	}

	@Override
	public boolean isInfoEnabled() {
		return level.compareTo(Level.INFO) <= 0;
	}

	@Override
	public void info(String format, Object... arguments) {
		log(Level.INFO, format, arguments);
	}

	@Override
	public void info(Throwable t, String format, Object... arguments) {
		log(Level.INFO, t, format, arguments);
	}

	@Override
	public boolean isWarnEnabled() {
		return level.compareTo(Level.WARN) <= 0;
	}

	@Override
	public void warn(String format, Object... arguments) {
		log(Level.WARN, format, arguments);
	}

	@Override
	public void warn(Throwable t, String format, Object... arguments) {
		log(Level.WARN, t, format, arguments);
	}

	@Override
	public boolean isErrorEnabled() {
		return level.compareTo(Level.ERROR) <= 0;
	}

	@Override
	public void error(String format, Object... arguments) {
		log(Level.ERROR, format, arguments);
	}

	@Override
	public void error(Throwable t, String format, Object... arguments) {
		log(Level.ERROR, t, format, arguments);
	}

	@Override
	public void log(Level level, String format, Object... arguments) {
		this.log(level, null, format, arguments);
	}

	@Override
	public void log(Level level, Throwable t, String format, Object... arguments) {
		if(!isEnabled(level)){
			return;
		}
		
		//[{date}] [{level}] {name}: {msg}
		String now = TimeUtil.format(LocalDateTime.now());
		String levelStr = level.toString();
		String msg = StringUtil.substitute(format, arguments);

		String stack = this.name;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int stackIndex = 4;
		if(stackTraceElements.length >= stackIndex+1){
            StackTraceElement stackTraceElement = stackTraceElements[stackIndex];
            stack = stackTraceElement.toString();
        }
		String logMsg = StringUtil.substitute("[{}] [{}] - {} - {}", now, levelStr, stack, msg);

		//WARN以上级别打印至System.err
		if(level.ordinal() >= Level.WARN.ordinal()){
			Console.error(t, logMsg);
		}else{
			Console.log(t, logMsg);
		}
	}

}
