/*
 * Decompiled with CFR 0.152.
 */
package jexx.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jexx.collect.LinkedStringKeyMap;
import jexx.collect.StringKeyMap;
import jexx.exception.IORuntimeException;
import jexx.json.Json;
import jexx.util.ClassUtil;
import jexx.util.CollectionUtil;

class JacksonJson
implements Json {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonJson() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        if (ClassUtil.exist((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule")) {
            this.mapper.registerModule((Module)new JavaTimeModule());
        }
        this.mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
    }

    @Override
    public <T> T parseObject(String input, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(input, clazz);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> T parseObject(InputStream input, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(input, clazz);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> parseList(String input, Class<T> clazz) {
        try {
            return (List)this.mapper.readValue(input, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> parseList(InputStream input, Class<T> clazz) {
        try {
            return (List)this.mapper.readValue(input, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StringKeyMap parseMap(String input) {
        LinkedStringKeyMap map = this.parseObject(input, LinkedStringKeyMap.class);
        LinkedStringKeyMap result = new LinkedStringKeyMap(map.size());
        this.scanMap((Map<String, Object>)result, (Map<?, ?>)map);
        return result;
    }

    @Override
    public StringKeyMap parseMap(InputStream input) {
        LinkedStringKeyMap map = this.parseObject(input, LinkedStringKeyMap.class);
        LinkedStringKeyMap result = new LinkedStringKeyMap(map.size());
        this.scanMap((Map<String, Object>)result, (Map<?, ?>)map);
        return result;
    }

    @Override
    public List<?> parseMapList(String input) {
        List<Object> list = this.parseList(input, Object.class);
        ArrayList<Object> result = new ArrayList<Object>();
        this.scanList(result, list);
        return result;
    }

    private void scanMap(Map<String, Object> map, Map<?, ?> value) {
        if (CollectionUtil.isEmpty(value)) {
            return;
        }
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            if (v instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>(((List)v).size());
                this.scanList(list, (List)v);
                map.put(k, list);
                continue;
            }
            if (v instanceof Map) {
                LinkedStringKeyMap map1 = new LinkedStringKeyMap(((Map)v).size());
                this.scanMap((Map<String, Object>)map1, (Map)v);
                map.put(k, map1);
                continue;
            }
            map.put(k, v);
        }
    }

    private void scanList(List<Object> list, List<?> values) {
        if (CollectionUtil.isEmpty(values)) {
            return;
        }
        for (Object value : values) {
            if (value instanceof List) {
                ArrayList<Object> list1 = new ArrayList<Object>(((List)value).size());
                this.scanList(list1, (List)value);
                list.add(list1);
                continue;
            }
            if (value instanceof Map) {
                LinkedStringKeyMap map = new LinkedStringKeyMap(((Map)value).size());
                this.scanMap((Map<String, Object>)map, (Map)value);
                list.add(map);
                continue;
            }
            list.add(value);
        }
    }

    @Override
    public String toJSONString(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

