/*
 * Decompiled with CFR 0.152.
 */
package jexx.json;

import java.io.InputStream;
import jexx.json.FastJsonJson;
import jexx.json.JacksonJson;
import jexx.json.Json;
import jexx.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final Json json;

    public static <T> T parseObject(String input, Class<T> clazz) {
        return json.parseObject(input, clazz);
    }

    public static <T> T parseObject(InputStream inputStream, Class<T> clazz) {
        return json.parseObject(inputStream, clazz);
    }

    public static String toJSONString(Object object) {
        return json.toJSONString(object);
    }

    static {
        ClassLoader classLoader = JsonUtil.class.getClassLoader();
        boolean jackson2Present = ClassUtil.exist((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader);
        boolean fastjson2Present = ClassUtil.exist((String)"com.alibaba.fastjson.JSON", (ClassLoader)classLoader);
        if (jackson2Present) {
            json = new JacksonJson();
            log.info("JsonUtil select jackson!");
        } else if (fastjson2Present) {
            json = new FastJsonJson();
            log.info("JsonUtil select fastjson!");
        } else {
            throw new Error("Please provide a json jar");
        }
    }
}

