/*
 * Decompiled with CFR 0.152.
 */
package jexx.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONReader;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jexx.collect.LinkedStringKeyMap;
import jexx.collect.StringKeyMap;
import jexx.exception.IORuntimeException;
import jexx.json.Json;
import jexx.util.CollectionUtil;

class FastJsonJson
implements Json {
    FastJsonJson() {
    }

    @Override
    public <T> T parseObject(String input, Class<T> clazz) {
        return (T)JSON.parseObject((String)input, clazz);
    }

    @Override
    public <T> T parseObject(InputStream input, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((InputStream)input, clazz, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> parseList(String input, Class<T> clazz) {
        return JSON.parseArray((String)input, clazz);
    }

    @Override
    public <T> List<T> parseList(InputStream input, Class<T> clazz) {
        JSONReader jsonReader = new JSONReader((Reader)new InputStreamReader(input));
        jsonReader.startArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (jsonReader.hasNext()) {
            Object t = jsonReader.readObject(clazz);
            list.add(t);
        }
        return list;
    }

    public LinkedStringKeyMap parseMap(String input) {
        JSONObject jsonObject = JSON.parseObject((String)input);
        if (jsonObject == null) {
            return null;
        }
        LinkedStringKeyMap map = new LinkedStringKeyMap(jsonObject.size());
        this.scanJSONObject(map, jsonObject);
        return map;
    }

    @Override
    public StringKeyMap parseMap(InputStream input) {
        JSONObject jsonObject = this.parseObject(input, JSONObject.class);
        if (jsonObject == null) {
            return null;
        }
        LinkedStringKeyMap map = new LinkedStringKeyMap(jsonObject.size());
        this.scanJSONObject(map, jsonObject);
        return map;
    }

    @Override
    public List<?> parseMapList(String input) {
        JSONArray jsonArray = JSON.parseArray((String)input);
        ArrayList<Object> result = new ArrayList<Object>();
        this.scanJSONArray(result, jsonArray);
        return result;
    }

    private void scanJSONObject(LinkedStringKeyMap map, JSONObject jsonObject) {
        if (CollectionUtil.isEmpty((Map)jsonObject)) {
            return;
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                ArrayList<Object> list = new ArrayList<Object>(((JSONArray)value).size());
                this.scanJSONArray(list, (JSONArray)value);
                map.put(key, list);
                continue;
            }
            if (value instanceof JSONObject) {
                LinkedStringKeyMap map1 = new LinkedStringKeyMap(((JSONObject)value).size());
                this.scanJSONObject(map1, (JSONObject)value);
                map.put(key, (Object)map1);
                continue;
            }
            map.put(key, value);
        }
    }

    private void scanJSONArray(List<Object> list, JSONArray array) {
        if (CollectionUtil.isEmpty((Collection)array)) {
            return;
        }
        for (Object obj : array) {
            if (obj instanceof JSONArray) {
                ArrayList<Object> list1 = new ArrayList<Object>(((JSONArray)obj).size());
                this.scanJSONArray(list1, (JSONArray)obj);
                list.add(list1);
                continue;
            }
            if (obj instanceof JSONObject) {
                LinkedStringKeyMap map = new LinkedStringKeyMap(((JSONObject)obj).size());
                this.scanJSONObject(map, (JSONObject)obj);
                list.add(map);
                continue;
            }
            list.add(obj);
        }
    }

    @Override
    public String toJSONString(Object object) {
        return JSON.toJSONString((Object)object);
    }
}

