/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jexx.io.ByteArrayResource;
import jexx.io.Resource;
import jexx.util.CollectionUtil;

public class RequestBody
extends OutputStream {
    private final List<Resource> resources = new ArrayList<Resource>(4);
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private boolean streaming;
    private int count;

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        ++this.count;
    }

    public void writeResource(Resource resource) {
        this.handleBuffer();
        this.resources.add(resource);
        if (!this.streaming && !resource.isBuffered()) {
            this.streaming = true;
        }
    }

    private void handleBuffer() {
        if (this.buffer.size() > 0) {
            ByteArrayResource r1 = new ByteArrayResource(this.buffer.toByteArray());
            this.resources.add((Resource)r1);
            this.buffer = new ByteArrayOutputStream();
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.handleBuffer();
        if (CollectionUtil.isEmpty(this.resources)) {
            return;
        }
        for (Resource resource : this.resources) {
            byte[] buffer = new byte[4096];
            InputStream inputStream = resource.getInputStream();
            Throwable throwable = null;
            try {
                int readSize;
                while (-1 != (readSize = inputStream.read(buffer))) {
                    outputStream.write(buffer, 0, readSize);
                    outputStream.flush();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public int size() {
        return this.count;
    }
}

