/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import jexx.http.DefaultHttp;
import jexx.http.Http;
import jexx.http.client.AbstractClientHttpRequestFactory;
import jexx.http.client.ClientHttpRequestFactory;
import jexx.http.client.HttpComponentsClientHttpRequestFactory;
import jexx.http.client.SSLContextFactory;
import jexx.http.client.SimpleClientHttpRequestFactory;
import jexx.http.client.ssl.DefaultSSLContextFactory;
import jexx.http.client.ssl.NoopSSLContextFactory;
import jexx.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpBuilder.class);
    private static final boolean HTTP_COMPONENTS_PRESENT;
    private SSLContextFactory sslContextFactory;
    private ClientHttpRequestFactory requestFactory;
    private static boolean ignoreSsl;

    private HttpBuilder() {
    }

    public HttpBuilder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        return this;
    }

    public static void setIgnoreSsl(boolean ignoreSsl) {
        HttpBuilder.ignoreSsl = ignoreSsl;
    }

    public HttpBuilder sslIgnore() {
        this.sslContextFactory = new NoopSSLContextFactory();
        return this;
    }

    public HttpBuilder sslLoad(byte[] cert, String password) {
        this.sslContextFactory = new DefaultSSLContextFactory(cert, password.toCharArray());
        return this;
    }

    public Http build() {
        if (this.requestFactory == null) {
            this.requestFactory = HTTP_COMPONENTS_PRESENT ? new HttpComponentsClientHttpRequestFactory() : new SimpleClientHttpRequestFactory();
        }
        if (this.requestFactory instanceof AbstractClientHttpRequestFactory) {
            SSLContextFactory sslContextFactory;
            if (this.sslContextFactory instanceof NoopSSLContextFactory) {
                sslContextFactory = this.sslContextFactory;
            } else if (ignoreSsl) {
                if (this.sslContextFactory != null) {
                    log.debug("'ignoreSsl' is true, so ignore the sslContextFactory");
                }
                sslContextFactory = new NoopSSLContextFactory();
            } else {
                sslContextFactory = this.sslContextFactory;
            }
            ((AbstractClientHttpRequestFactory)this.requestFactory).setSslContextFactory(sslContextFactory);
        }
        return new DefaultHttp(this.requestFactory);
    }

    public static HttpBuilder create() {
        return new HttpBuilder();
    }

    static {
        ClassLoader classLoader = HttpBuilder.class.getClassLoader();
        HTTP_COMPONENTS_PRESENT = ClassUtil.exist((String)"org.apache.http.client.HttpClient", (ClassLoader)classLoader);
    }
}

