/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert.json;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.io.IOUtil;
import jexx.json.JsonUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexxJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JexxJsonHttpMessageConverter.class);

    public JexxJsonHttpMessageConverter() {
        super(null, ContentType.APPLICATION_JSON);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        if (logger.isDebugEnabled()) {
            byte[] bodyBytes = IOUtil.readBytes((InputStream)inputMessage.getBody());
            Charset charset = this.getCharset(inputMessage.getHeaders().getContentType());
            String body = StringUtil.str((byte[])bodyBytes, (Charset)charset);
            logger.debug("read json= {}", (Object)body);
            return JsonUtil.parseObject((String)body, clazz);
        }
        return JsonUtil.parseObject((InputStream)inputMessage.getBody(), clazz);
    }

    @Override
    protected void writeInternal(Object object, ContentType contentType, HttpOutputMessage httpOutputMessage) throws IOException {
        String json = JsonUtil.toJSONString((Object)object);
        Charset charset = this.getCharset(contentType);
        byte[] buffer = StringUtil.getBytes((String)json, (Charset)charset);
        this.writeBody(httpOutputMessage.getBody(), buffer);
    }
}

