/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert.json;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.io.IOUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JacksonHttpMessageConverter.class);
    private final ObjectMapper objectMapper;

    public JacksonHttpMessageConverter() {
        this(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false), false);
    }

    public JacksonHttpMessageConverter(ObjectMapper objectMapper, boolean readStream) {
        super(null, ContentType.APPLICATION_JSON);
        this.objectMapper = objectMapper;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        if (logger.isDebugEnabled()) {
            byte[] bodyBytes = IOUtil.readBytes((InputStream)inputMessage.getBody());
            Charset charset = this.getCharset(inputMessage.getHeaders().getContentType());
            String body = StringUtil.str((byte[])bodyBytes, (Charset)charset);
            logger.debug("read json= {}", (Object)body);
            return this.objectMapper.readValue(bodyBytes, clazz);
        }
        return this.objectMapper.readValue(inputMessage.getBody(), clazz);
    }

    @Override
    protected void writeInternal(Object object, ContentType contentType, HttpOutputMessage httpOutputMessage) throws IOException {
        String json = JSON.toJSONString((Object)object);
        Charset charset = this.getCharset(contentType);
        byte[] buffer = StringUtil.getBytes((String)json, (Charset)charset);
        this.writeBody(httpOutputMessage.getBody(), buffer);
    }
}

