/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.client.ssl;

import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import jexx.http.client.SSLContextFactory;
import jexx.http.client.ssl.NoopHostnameVerifier;
import jexx.http.client.ssl.NoopTrustManager;

public class NoopSSLContextFactory
implements SSLContextFactory {
    public static final NoopSSLContextFactory INSTANCE = new NoopSSLContextFactory();

    @Override
    public SSLContext getSSLContext() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], this.getTrustManagers(), new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            return ctx;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to create SSLContext", e);
        }
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return new TrustManager[]{NoopTrustManager.INSTANCE};
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return NoopHostnameVerifier.INSTANCE;
    }
}

