/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import jexx.http.HttpMethod;
import jexx.http.client.AbstractClientHttpRequestFactory;
import jexx.http.client.ClientHttpRequest;
import jexx.http.client.ClientHttpRequestFactory;
import jexx.http.client.SimpleClientHttpRequest;

public class SimpleClientHttpRequestFactory
extends AbstractClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private Proxy proxy;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private int chunkSize = 4096;

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpURLConnection connection = this.openConnection(uri.toURL(), this.proxy);
        this.prepareConnection(connection, httpMethod.name());
        return new SimpleClientHttpRequest(connection);
    }

    protected HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        URLConnection urlConnection;
        URLConnection uRLConnection = urlConnection = proxy != null ? url.openConnection(proxy) : url.openConnection();
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new IllegalStateException("HttpURLConnection required for [" + url + "] but got: " + urlConnection);
        }
        if (urlConnection instanceof HttpsURLConnection && this.sslContextFactory != null) {
            SSLContext sslContext = this.sslContextFactory.getSSLContext();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(this.sslContextFactory.getHostnameVerifier());
        }
        return (HttpURLConnection)urlConnection;
    }

    protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
        if (this.connectTimeout >= 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects("GET".equals(httpMethod));
        connection.setDoOutput("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod) || "DELETE".equals(httpMethod));
        connection.setRequestMethod(httpMethod);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }
}

