/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import jexx.http.HttpHeaders;
import jexx.http.HttpStatus;

public class ResponseEntity<T> {
    private final int status;
    private final HttpHeaders headers;
    private final T body;
    private final HttpStatus httpStatus;

    public ResponseEntity(int status) {
        this(status, null);
    }

    public ResponseEntity(int status, HttpHeaders headers) {
        this(status, headers, null);
    }

    public ResponseEntity(int status, HttpHeaders headers, T body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.httpStatus = HttpStatus.resolve(status);
    }

    public int getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public String toString() {
        return "ResponseEntity{status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + '}';
    }
}

