/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.net.URI;
import jexx.http.HttpHeaders;
import jexx.http.HttpMethod;
import jexx.http.HttpRequestCallback;
import jexx.http.HttpResponseExtractor;
import jexx.http.RequestEntity;
import jexx.http.ResponseEntity;

public interface Http {
    default public <T> T getForObject(String url, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.GET, RequestEntity.EMPTY, responseType);
    }

    default public <T> T getForObject(String url, HttpHeaders headers, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.GET, new RequestEntity<Object>(null, headers), responseType);
    }

    default public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.GET, RequestEntity.EMPTY, responseType);
    }

    default public <T> ResponseEntity<T> getForEntity(String url, HttpHeaders headers, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.GET, new RequestEntity<Object>(null, headers), responseType);
    }

    default public <T> T postForObject(String url, Object request, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.POST, RequestEntity.unwrap(request), responseType);
    }

    default public <T> T postForObject(String url, HttpHeaders headers, Object request, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.POST, new RequestEntity<Object>(request, headers), responseType);
    }

    default public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.POST, RequestEntity.unwrap(request), responseType);
    }

    default public <T> ResponseEntity<T> postForEntity(String url, HttpHeaders headers, Object request, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.POST, new RequestEntity<Object>(request, headers), responseType);
    }

    default public <T> T putForObject(String url, Object request, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.PUT, RequestEntity.unwrap(request), responseType);
    }

    default public <T> T putForObject(String url, HttpHeaders headers, Object request, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.PUT, new RequestEntity<Object>(request, headers), responseType);
    }

    default public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.PUT, RequestEntity.unwrap(request), responseType);
    }

    default public <T> ResponseEntity<T> putForEntity(String url, HttpHeaders headers, Object request, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.PUT, new RequestEntity<Object>(request, headers), responseType);
    }

    default public <T> T deleteForObject(String url, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.DELETE, RequestEntity.EMPTY, responseType);
    }

    default public <T> T deleteForObject(String url, HttpHeaders headers, Class<T> responseType) {
        return this.exchangeForObject(url, HttpMethod.DELETE, new RequestEntity<Object>(null, headers), responseType);
    }

    default public <T> ResponseEntity<T> deleteForEntity(String url, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.DELETE, RequestEntity.EMPTY, responseType);
    }

    default public <T> ResponseEntity<T> deleteForEntity(String url, HttpHeaders headers, Class<T> responseType) {
        return this.exchangeForEntity(url, HttpMethod.DELETE, new RequestEntity<Object>(null, headers), responseType);
    }

    public <T> T exchangeForObject(String var1, HttpMethod var2, RequestEntity<?> var3, Class<T> var4);

    public <T> ResponseEntity<T> exchangeForEntity(String var1, HttpMethod var2, RequestEntity<?> var3, Class<T> var4);

    public <T> T exchangeForObject(URI var1, HttpMethod var2, RequestEntity<?> var3, Class<T> var4);

    public <T> ResponseEntity<T> exchangeForEntity(URI var1, HttpMethod var2, RequestEntity<?> var3, Class<T> var4);

    public <T> T execute(String var1, HttpMethod var2, HttpRequestCallback var3, HttpResponseExtractor<T> var4);

    public <T> T execute(URI var1, HttpMethod var2, HttpRequestCallback var3, HttpResponseExtractor<T> var4);
}

