/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jexx.http.ContentType;
import jexx.http.Http;
import jexx.http.HttpHeaders;
import jexx.http.HttpMethod;
import jexx.http.HttpRequest;
import jexx.http.HttpRequestCallback;
import jexx.http.HttpResponse;
import jexx.http.HttpResponseExtractor;
import jexx.http.RequestEntity;
import jexx.http.ResponseEntity;
import jexx.http.client.ClientHttpRequest;
import jexx.http.client.ClientHttpRequestFactory;
import jexx.http.client.ClientHttpResponse;
import jexx.http.client.SimpleClientHttpRequestFactory;
import jexx.http.convert.ByteArrayHttpMessageConverter;
import jexx.http.convert.FormHttpMessageConverter;
import jexx.http.convert.HttpMessageConverter;
import jexx.http.convert.ResourceHttpMessageConverter;
import jexx.http.convert.StringHttpMessageConverter;
import jexx.http.convert.json.FastjsonHttpMessageConverter;
import jexx.http.convert.json.JacksonHttpMessageConverter;
import jexx.http.convert.json.JexxJsonHttpMessageConverter;
import jexx.http.convert.xml.JaxbHttpMessageConverter;
import jexx.http.exception.HttpException;
import jexx.io.IOUtil;
import jexx.util.Assert;
import jexx.util.ClassUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttp
implements Http {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttp.class);
    private static final boolean jackson2Present;
    private static final boolean fastjson2Present;
    private static final boolean jexxjson2Present;
    private final List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private ClientHttpRequestFactory clientHttpRequestFactory;

    public DefaultHttp() {
        this(new SimpleClientHttpRequestFactory());
    }

    public DefaultHttp(ClientHttpRequestFactory requestFactory) {
        this.messageConverters.add(new ByteArrayHttpMessageConverter());
        this.messageConverters.add(new StringHttpMessageConverter());
        this.messageConverters.add(new FormHttpMessageConverter());
        if (jexxjson2Present) {
            this.messageConverters.add(new JexxJsonHttpMessageConverter());
        } else if (jackson2Present) {
            this.messageConverters.add(new JacksonHttpMessageConverter());
        } else if (fastjson2Present) {
            this.messageConverters.add(new FastjsonHttpMessageConverter());
        }
        this.messageConverters.add(new JaxbHttpMessageConverter());
        this.messageConverters.add(new ResourceHttpMessageConverter());
        this.clientHttpRequestFactory = requestFactory == null ? new SimpleClientHttpRequestFactory() : requestFactory;
    }

    public void setClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        if (clientHttpRequestFactory != null) {
            this.clientHttpRequestFactory = clientHttpRequestFactory;
        }
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    @Override
    public <T> T exchangeForObject(String url, HttpMethod method, RequestEntity<?> httpEntity, Class<T> responseType) {
        HttpRequestCallback callback = this.createHttpEntityRequestCallback(httpEntity);
        HttpMessageConverterExtractor<T> responseExtractor = this.createObjectExtractor(responseType);
        return this.execute(url, method, callback, responseExtractor);
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(String url, HttpMethod method, RequestEntity<?> httpEntity, Class<T> responseType) {
        HttpRequestCallback callback = this.createHttpEntityRequestCallback(httpEntity);
        ResponseEntityResponseExtractor<T> responseExtractor = this.createResponseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, method, callback, responseExtractor);
    }

    @Override
    public <T> T exchangeForObject(URI url, HttpMethod method, RequestEntity<?> httpEntity, Class<T> responseType) {
        HttpRequestCallback callback = this.createHttpEntityRequestCallback(httpEntity);
        HttpMessageConverterExtractor<T> responseExtractor = this.createObjectExtractor(responseType);
        return this.execute(url, method, callback, responseExtractor);
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(URI url, HttpMethod method, RequestEntity<?> httpEntity, Class<T> responseType) {
        HttpEntityRequestCallback callback = new HttpEntityRequestCallback(httpEntity);
        ResponseEntityResponseExtractor<T> responseExtractor = new ResponseEntityResponseExtractor<T>(responseType);
        return (ResponseEntity)this.execute(url, method, (HttpRequestCallback)callback, responseExtractor);
    }

    @Override
    public <T> T execute(String url, HttpMethod method, HttpRequestCallback requestCallback, HttpResponseExtractor<T> responseExtractor) {
        URI expanded = URI.create(url);
        return this.execute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> T execute(URI url, HttpMethod method, HttpRequestCallback requestCallback, HttpResponseExtractor<T> responseExtractor) {
        return this.doExecute(url, method, requestCallback, responseExtractor);
    }

    protected <T> T doExecute(URI url, HttpMethod method, HttpRequestCallback requestCallback, HttpResponseExtractor<T> responseExtractor) {
        Assert.notNull((Object)url, (String)"URI is required", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)method), (String)"HttpMethod is required", (Object[])new Object[0]);
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.wrap(request);
            }
            response = request.execute();
            T t = responseExtractor != null ? (T)responseExtractor.extractData(response) : null;
            return t;
        }
    }

    protected HttpRequestCallback createAcceptedRequestCallback(Class<?> responseType) {
        return new AcceptedRequestCallback(responseType);
    }

    protected HttpRequestCallback createHttpEntityRequestCallback(Object entity) {
        return new HttpEntityRequestCallback(entity);
    }

    protected <T> HttpMessageConverterExtractor<T> createObjectExtractor(Class<T> responseType) {
        return new HttpMessageConverterExtractor<T>(responseType);
    }

    protected <T> ResponseEntityResponseExtractor<T> createResponseEntityExtractor(Class<T> responseType) {
        return new ResponseEntityResponseExtractor<T>(responseType);
    }

    static {
        ClassLoader classLoader = DefaultHttp.class.getClassLoader();
        jackson2Present = ClassUtil.exist((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader);
        fastjson2Present = ClassUtil.exist((String)"com.alibaba.fastjson.JSON", (ClassLoader)classLoader);
        jexxjson2Present = ClassUtil.exist((String)"jexx.json.Json", (ClassLoader)classLoader);
    }

    private class ResponseEntityResponseExtractor<T>
    implements HttpResponseExtractor<ResponseEntity<T>> {
        private final HttpMessageConverterExtractor<T> delegate;

        public ResponseEntityResponseExtractor(Class<T> responseClass) {
            this.delegate = new HttpMessageConverterExtractor<T>(responseClass);
        }

        @Override
        public ResponseEntity<T> extractData(HttpResponse response) throws IOException {
            T body = this.delegate.extractData(response);
            return new ResponseEntity<T>(response.getStatus(), response.getHeaders(), body);
        }
    }

    private class HttpMessageConverterExtractor<T>
    implements HttpResponseExtractor<T> {
        private final Class<T> responseClass;

        public HttpMessageConverterExtractor(Class<T> responseClass) {
            this.responseClass = responseClass;
        }

        @Override
        public T extractData(HttpResponse response) {
            ContentType contentType = this.getContentType(response);
            List<HttpMessageConverter<?>> messageConverters = DefaultHttp.this.getMessageConverters();
            for (HttpMessageConverter<T> httpMessageConverter : messageConverters) {
                if (!httpMessageConverter.supportRead(this.responseClass, contentType)) continue;
                return (T)httpMessageConverter.read(this.responseClass, response);
            }
            try {
                Throwable throwable = null;
                try (InputStream inputStream = response.getBody();){
                    byte[] buffer = IOUtil.readBytes((InputStream)inputStream);
                    log.error("response\uff1astatus={},headers={},body={}", new Object[]{response.getStatus(), response.getHeaders(), StringUtil.str((byte[])buffer)});
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            throw new HttpException("No HttpMessageConverter for " + this.responseClass.getName() + " and  content type \"" + contentType + "\"");
        }

        protected ContentType getContentType(HttpResponse response) {
            ContentType contentType = response.getHeaders().getContentType();
            if (contentType == null) {
                contentType = ContentType.APPLICATION_OCTET_STREAM;
            }
            return contentType;
        }
    }

    private class HttpEntityRequestCallback
    extends AcceptedRequestCallback {
        private final RequestEntity<?> entity;

        public HttpEntityRequestCallback(Object entity) {
            this(null, entity);
        }

        public HttpEntityRequestCallback(Class<?> responseType, Object entity) {
            super(responseType);
            this.entity = entity instanceof RequestEntity ? (RequestEntity<Object>)entity : (entity != null ? new RequestEntity<Object>(entity) : RequestEntity.EMPTY);
        }

        @Override
        public void wrap(HttpRequest request) {
            Object requestBody = this.entity.getBody();
            if (requestBody == null) {
                HttpHeaders httpHeaders = request.getHeaders();
                HttpHeaders requestHeaders = this.entity.getHeaders();
                if (!requestHeaders.isEmpty()) {
                    requestHeaders.forEach((key, values) -> httpHeaders.put((String)key, (List<String>)new LinkedList<String>((Collection<String>)values)));
                }
                if (httpHeaders.getContentLength() < 0L) {
                    httpHeaders.setContentLength(0L);
                }
            } else {
                Class<?> requestBodyClass = requestBody.getClass();
                HttpHeaders httpHeaders = request.getHeaders();
                HttpHeaders requestHeaders = this.entity.getHeaders();
                ContentType contentType = requestHeaders.getContentType();
                List<HttpMessageConverter<?>> messageConverters = DefaultHttp.this.getMessageConverters();
                for (HttpMessageConverter<?> converter : messageConverters) {
                    if (!converter.supportWrite(requestBodyClass, contentType)) continue;
                    if (!requestHeaders.isEmpty()) {
                        requestHeaders.forEach((key, values) -> httpHeaders.put((String)key, (List<String>)new LinkedList<String>((Collection<String>)values)));
                    }
                    converter.write(requestBody, contentType, request);
                    return;
                }
                throw new HttpException("No HttpMessageConverter for " + requestBodyClass.getName() + " and  content type \"" + contentType + "\"");
            }
        }
    }

    private class AcceptedRequestCallback
    implements HttpRequestCallback {
        private final Class<?> responseType;

        public AcceptedRequestCallback(Class<?> responseType) {
            this.responseType = responseType;
        }

        @Override
        public void wrap(HttpRequest request) {
            List<ContentType> contentTypes;
            if (this.responseType != null && CollectionUtil.isNotEmpty(contentTypes = this.fetchSupportReadContentTypeByResponseType(this.responseType))) {
                request.getHeaders().setAccept(contentTypes);
            }
        }

        private List<ContentType> fetchSupportReadContentTypeByResponseType(Class<?> responseType) {
            return DefaultHttp.this.getMessageConverters().stream().filter(s -> s.supportRead(responseType, null)).flatMap(s -> s.getSupportContentTypes().stream()).distinct().collect(Collectors.toList());
        }
    }
}

