/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import jexx.util.Assert;
import jexx.util.URLUtil;

public final class ContentDisposition {
    private final String type;
    private String name;
    private String filename;
    private Charset charset;
    private Long size;
    private ZonedDateTime creationDate;
    private ZonedDateTime modificationDate;
    private ZonedDateTime readDate;

    public ContentDisposition(String type) {
        this(type, null, null, null, null, null, null, null);
    }

    public ContentDisposition(String type, String name, String filename, Charset charset, Long size, ZonedDateTime creationDate, ZonedDateTime modificationDate, ZonedDateTime readDate) {
        Assert.hasText((String)type, (String)"type is not empty", (Object[])new Object[0]);
        this.type = type;
        this.name = name;
        this.filename = filename;
        this.charset = charset;
        this.size = size;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.readDate = readDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type);
        }
        if (this.name != null) {
            sb.append("; name=\"");
            sb.append(this.name).append('\"');
        }
        if (this.filename != null) {
            if (this.charset == null || StandardCharsets.US_ASCII.equals(this.charset)) {
                sb.append("; filename=\"");
                sb.append(this.filename).append('\"');
            } else {
                sb.append("; filename*=");
                sb.append(ContentDisposition.encodeFilename(this.filename, this.charset));
            }
        }
        if (this.size != null) {
            sb.append("; size=");
            sb.append(this.size);
        }
        if (this.creationDate != null) {
            sb.append("; creation-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.creationDate));
            sb.append('\"');
        }
        if (this.modificationDate != null) {
            sb.append("; modification-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.modificationDate));
            sb.append('\"');
        }
        if (this.readDate != null) {
            sb.append("; read-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.readDate));
            sb.append('\"');
        }
        return sb.toString();
    }

    public static ContentDisposition empty() {
        return new ContentDisposition("", null, null, null, null, null, null, null);
    }

    public static ContentDisposition parse(String contentDisposition) {
        List<String> parts = ContentDisposition.tokenize(contentDisposition);
        String type = parts.get(0);
        String name = null;
        String filename = null;
        Charset charset = null;
        Long size = null;
        ZonedDateTime creationDate = null;
        ZonedDateTime modificationDate = null;
        ZonedDateTime readDate = null;
        for (int i = 1; i < parts.size(); ++i) {
            String part = parts.get(i);
            int eqIndex = part.indexOf(61);
            if (eqIndex != -1) {
                String value;
                String attribute = part.substring(0, eqIndex);
                String string = value = part.startsWith("\"", eqIndex + 1) && part.endsWith("\"") ? part.substring(eqIndex + 2, part.length() - 1) : part.substring(eqIndex + 1);
                if ("name".equals(attribute)) {
                    name = value;
                    continue;
                }
                if ("filename*".equals(attribute)) {
                    int idx1 = value.indexOf(39);
                    int idx2 = value.indexOf(39, idx1 + 1);
                    if (idx1 != -1 && idx2 != -1) {
                        charset = Charset.forName(value.substring(0, idx1));
                        Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1", (Object[])new Object[0]);
                        filename = ContentDisposition.decodeFilename(value.substring(idx2 + 1), charset);
                        continue;
                    }
                    filename = ContentDisposition.decodeFilename(value, StandardCharsets.US_ASCII);
                    continue;
                }
                if ("filename".equals(attribute) && filename == null) {
                    filename = value;
                    continue;
                }
                if ("size".equals(attribute)) {
                    size = Long.parseLong(value);
                    continue;
                }
                if ("creation-date".equals(attribute)) {
                    try {
                        creationDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue;
                }
                if ("modification-date".equals(attribute)) {
                    try {
                        modificationDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue;
                }
                if (!"read-date".equals(attribute)) continue;
                try {
                    readDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                }
                catch (DateTimeParseException dateTimeParseException) {}
                continue;
            }
            throw new IllegalArgumentException("Invalid content disposition format");
        }
        return new ContentDisposition(type, name, filename, charset, size, creationDate, modificationDate, readDate);
    }

    private static List<String> tokenize(String headerValue) {
        int index = headerValue.indexOf(59);
        String type = (index >= 0 ? headerValue.substring(0, index) : headerValue).trim();
        if (type.isEmpty()) {
            throw new IllegalArgumentException("Content-Disposition header must not be empty");
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(type);
        if (index >= 0) {
            int nextIndex;
            do {
                String part;
                boolean quoted = false;
                boolean escaped = false;
                for (nextIndex = index + 1; nextIndex < headerValue.length(); ++nextIndex) {
                    char ch = headerValue.charAt(nextIndex);
                    if (ch == ';') {
                        if (!quoted) {
                            break;
                        }
                    } else if (!escaped && ch == '\"') {
                        quoted = !quoted;
                    }
                    escaped = !escaped && ch == '\\';
                }
                if ((part = headerValue.substring(index + 1, nextIndex).trim()).isEmpty()) continue;
                parts.add(part);
            } while ((index = nextIndex) < headerValue.length());
        }
        return parts;
    }

    private static String decodeFilename(String filename, Charset charset) {
        Assert.notNull((Object)filename, (String)"'filename' should not be null", (Object[])new Object[0]);
        Assert.notNull((Object)charset, (String)"'charset' should not be null", (Object[])new Object[0]);
        return URLUtil.decode((String)filename, (String)charset.name());
    }

    private static String encodeFilename(String input, Charset charset) {
        Assert.notNull((Object)input, (String)"'input' String should not be null", (Object[])new Object[0]);
        Assert.notNull((Object)charset, (String)"'charset' should not be null", (Object[])new Object[0]);
        return URLUtil.encode((String)input, (Charset)charset);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(ZonedDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ZonedDateTime getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(ZonedDateTime modificationDate) {
        this.modificationDate = modificationDate;
    }

    public ZonedDateTime getReadDate() {
        return this.readDate;
    }

    public void setReadDate(ZonedDateTime readDate) {
        this.readDate = readDate;
    }
}

