/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jexx.exception.IORuntimeException;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.RequestBody;
import jexx.http.convert.HttpMessageConverter;
import jexx.util.Assert;

public abstract class AbstractHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private Charset defaultCharset = DEFAULT_CHARSET;
    private List<ContentType> supportedContentTypes = Collections.emptyList();

    public AbstractHttpMessageConverter(Charset defaultCharset, ContentType ... supportedContentTypes) {
        if (defaultCharset != null) {
            this.defaultCharset = defaultCharset;
        }
        this.setSupportedContentTypes(Arrays.asList(supportedContentTypes));
    }

    public void setSupportedContentTypes(List<ContentType> supportedContentTypes) {
        Assert.notEmpty(supportedContentTypes, (String)"MediaType List must not be empty", (Object[])new Object[0]);
        this.supportedContentTypes = new ArrayList<ContentType>(supportedContentTypes);
    }

    @Override
    public List<ContentType> getSupportContentTypes() {
        return Collections.unmodifiableList(this.supportedContentTypes);
    }

    protected abstract boolean supports(Class<?> var1);

    protected boolean supportRead(ContentType contentType) {
        if (contentType == null) {
            return true;
        }
        for (ContentType ct : this.getSupportContentTypes()) {
            if (!ct.include(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportRead(Class<?> clazz, ContentType contentType) {
        return this.supports(clazz) && this.supportRead(contentType);
    }

    @Override
    public final T read(Class<? extends T> clazz, HttpInputMessage inputMessage) {
        try {
            return this.readInternal(clazz, inputMessage);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    protected abstract T readInternal(Class<? extends T> var1, HttpInputMessage var2) throws IOException;

    protected boolean supportWrite(ContentType contentType) {
        if (contentType == null) {
            return true;
        }
        for (ContentType ct : this.getSupportContentTypes()) {
            if (!ct.include(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean supportWrite(Class<?> clazz, ContentType contentType) {
        return this.supports(clazz) && this.supportWrite(contentType);
    }

    @Override
    public final void write(T t, ContentType contentType, HttpOutputMessage httpOutputMessage) {
        try {
            this.writeInternal(t, contentType, httpOutputMessage);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    protected abstract void writeInternal(T var1, ContentType var2, HttpOutputMessage var3) throws IOException;

    protected void writeBody(RequestBody body, byte[] buffer) throws IOException {
        body.write(buffer);
    }

    protected Charset getCharset(ContentType contentType) {
        if (contentType == null) {
            return this.defaultCharset;
        }
        Charset charset = contentType.getCharset();
        if (charset == null) {
            charset = this.defaultCharset;
        }
        return charset;
    }
}

