/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import jexx.http.HttpHeaders;
import jexx.http.RequestBody;
import jexx.http.client.AbstractClientHttpRequest;
import jexx.http.client.ClientHttpResponse;
import jexx.http.client.HttpComponentsClientHttpResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.protocol.HttpContext;

class HttpComponentsClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpUriRequest httpRequest;
    private final HttpContext httpContext;

    public HttpComponentsClientHttpRequest(HttpClient httpClient, HttpUriRequest httpRequest, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpRequest = httpRequest;
        this.httpContext = httpContext;
    }

    @Override
    public URI getURI() {
        return this.httpRequest.getURI();
    }

    @Override
    public String getMethodValue() {
        return this.httpRequest.getMethod();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        this.addHeaders(this.httpRequest, headers);
        if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.httpRequest;
            StreamHttpEntity requestEntity = new StreamHttpEntity(this.getBody());
            entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
        }
        HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
        return new HttpComponentsClientHttpResponse(httpResponse);
    }

    private void addHeaders(HttpUriRequest httpRequest, HttpHeaders headers) {
        headers.forEach((headerName, headerValues) -> {
            if (!"Content-Length".equalsIgnoreCase((String)headerName) && !"Transfer-Encoding".equalsIgnoreCase((String)headerName)) {
                for (String headerValue : headerValues) {
                    httpRequest.addHeader(headerName, headerValue);
                }
            }
        });
    }

    private static class StreamHttpEntity
    extends AbstractHttpEntity {
        private final RequestBody body;

        public StreamHttpEntity(RequestBody body) {
            this.body = body;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outStream) throws IOException {
            this.body.writeTo(outStream);
        }

        public boolean isStreaming() {
            return true;
        }
    }
}

