/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.io.IOUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastjsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(FastjsonHttpMessageConverter.class);

    public FastjsonHttpMessageConverter() {
        super(null, ContentType.APPLICATION_JSON);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        if (logger.isDebugEnabled()) {
            byte[] bodyBytes = IOUtil.readBytes((InputStream)inputMessage.getBody());
            Charset charset = this.getCharset(inputMessage.getHeaders().getContentType());
            String body = StringUtil.str((byte[])bodyBytes, (Charset)charset);
            logger.debug("read json= {}", (Object)body);
            return JSON.parseObject((byte[])bodyBytes, clazz, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((InputStream)inputMessage.getBody(), clazz, (Feature[])new Feature[0]);
    }

    @Override
    protected void writeInternal(Object o, ContentType contentType, HttpOutputMessage outputMessage) throws IOException {
        String json = JSON.toJSONString((Object)o);
        outputMessage.getBody().write(StringUtil.getBytes((String)json, (Charset)this.getCharset(contentType)));
        outputMessage.getBody().flush();
    }
}

