/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.io.IOUtil;
import jexx.util.StringUtil;

public class StringHttpMessageConverter
extends AbstractHttpMessageConverter<String> {
    public StringHttpMessageConverter() {
        super(DEFAULT_CHARSET, ContentType.TEXT_PLAIN, ContentType.ALL);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return String.class == clazz;
    }

    @Override
    protected String readInternal(Class<? extends String> clazz, HttpInputMessage inputMessage) throws IOException {
        Charset charset = this.getCharset(inputMessage.getHeaders().getContentType());
        byte[] response = IOUtil.readBytes((InputStream)inputMessage.getBody());
        return StringUtil.str((byte[])response, (Charset)charset);
    }

    @Override
    protected void writeInternal(String s, ContentType contentType, HttpOutputMessage outputMessage) throws IOException {
        Charset charset = this.getCharset(contentType);
        OutputStream outputStream = outputMessage.getBody();
        outputStream.write(s.getBytes(charset));
        outputStream.flush();
    }
}

