/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.convert;

import java.io.IOException;
import java.io.InputStream;
import jexx.http.ContentType;
import jexx.http.HttpInputMessage;
import jexx.http.HttpOutputMessage;
import jexx.http.convert.AbstractHttpMessageConverter;
import jexx.io.IOUtil;

public class ByteArrayHttpMessageConverter
extends AbstractHttpMessageConverter<byte[]> {
    public ByteArrayHttpMessageConverter() {
        super(null, ContentType.APPLICATION_OCTET_STREAM, ContentType.ALL);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return byte[].class == clazz;
    }

    @Override
    protected byte[] readInternal(Class<? extends byte[]> clazz, HttpInputMessage inputMessage) throws IOException {
        long contentLength = inputMessage.getHeaders().getContentLength();
        InputStream inputStream = inputMessage.getBody();
        return contentLength > 0L ? IOUtil.readBytes((InputStream)inputStream, (int)((int)contentLength)) : IOUtil.readBytes((InputStream)inputStream);
    }

    @Override
    protected void writeInternal(byte[] bytes, ContentType contentType, HttpOutputMessage outputMessage) throws IOException {
        outputMessage.getBody().write(bytes);
        outputMessage.getBody().flush();
    }
}

